/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.certificates.v1;

import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestCondition;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatus;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestStatusBuilder;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.CertificateSigningRequestResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.io.IOException;

public class CertificateSigningRequestOperationsImpl
extends HasMetadataOperation<CertificateSigningRequest, CertificateSigningRequestList, CertificateSigningRequestResource<CertificateSigningRequest>>
implements CertificateSigningRequestResource<CertificateSigningRequest> {
    public CertificateSigningRequestOperationsImpl(ClientContext clientContext) {
        this(clientContext, null);
    }

    public CertificateSigningRequestOperationsImpl(ClientContext clientContext, String namespace) {
        this(HasMetadataOperationsImpl.defaultContext(clientContext).withNamespace(namespace));
    }

    public CertificateSigningRequestOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("certificates.k8s.io").withApiGroupVersion("v1").withCascading(true).withPlural("certificatesigningrequests"), CertificateSigningRequest.class, CertificateSigningRequestList.class);
    }

    public CertificateSigningRequestOperationsImpl newInstance(OperationContext context) {
        return new CertificateSigningRequestOperationsImpl(context);
    }

    @Override
    public CertificateSigningRequest approve(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return this.approveOrDeny(certificateSigningRequestCondition);
    }

    @Override
    public CertificateSigningRequest deny(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return this.approveOrDeny(certificateSigningRequestCondition);
    }

    private CertificateSigningRequest approveOrDeny(CertificateSigningRequestCondition csrCondition) {
        try {
            CertificateSigningRequest fromServerCsr = (CertificateSigningRequest)this.fromServer().get();
            fromServerCsr.setStatus(this.createCertificateSigningRequestStatus(csrCondition));
            String uri = URLUtils.join(this.getResourceUrl(null, fromServerCsr.getMetadata().getName(), false).toString(), "approval");
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().put("application/json", JSON_MAPPER.writeValueAsString((Object)fromServerCsr)).uri(uri);
            return this.handleResponse(requestBuilder, CertificateSigningRequest.class);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("CeritificateSigningRequest " + this.type), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("CertificateSigningRequest " + this.type), (Throwable)e);
        }
    }

    private CertificateSigningRequestStatus createCertificateSigningRequestStatus(CertificateSigningRequestCondition certificateSigningRequestCondition) {
        return ((CertificateSigningRequestStatusBuilder)new CertificateSigningRequestStatusBuilder().addToConditions(certificateSigningRequestCondition)).build();
    }
}

