/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec;
import io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluentImpl;
import java.util.Objects;

public class ThanosSpecBuilder
extends ThanosSpecFluentImpl<ThanosSpecBuilder>
implements VisitableBuilder<ThanosSpec, ThanosSpecBuilder> {
    ThanosSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ThanosSpecBuilder() {
        this(true);
    }

    public ThanosSpecBuilder(Boolean validationEnabled) {
        this(new ThanosSpec(), validationEnabled);
    }

    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ThanosSpec(), validationEnabled);
    }

    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent, ThanosSpec instance) {
        this(fluent, instance, true);
    }

    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent, ThanosSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBaseImage(instance.getBaseImage());
        fluent.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
        fluent.withImage(instance.getImage());
        fluent.withListenLocal(instance.getListenLocal());
        fluent.withLogFormat(instance.getLogFormat());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withMinTime(instance.getMinTime());
        fluent.withObjectStorageConfig(instance.getObjectStorageConfig());
        fluent.withResources(instance.getResources());
        fluent.withSha(instance.getSha());
        fluent.withTag(instance.getTag());
        fluent.withTracingConfig(instance.getTracingConfig());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public ThanosSpecBuilder(ThanosSpec instance) {
        this(instance, (Boolean)true);
    }

    public ThanosSpecBuilder(ThanosSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBaseImage(instance.getBaseImage());
        this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
        this.withImage(instance.getImage());
        this.withListenLocal(instance.getListenLocal());
        this.withLogFormat(instance.getLogFormat());
        this.withLogLevel(instance.getLogLevel());
        this.withMinTime(instance.getMinTime());
        this.withObjectStorageConfig(instance.getObjectStorageConfig());
        this.withResources(instance.getResources());
        this.withSha(instance.getSha());
        this.withTag(instance.getTag());
        this.withTracingConfig(instance.getTracingConfig());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ThanosSpec build() {
        ThanosSpec buildable = new ThanosSpec(this.fluent.getBaseImage(), this.fluent.getGrpcServerTlsConfig(), this.fluent.getImage(), this.fluent.isListenLocal(), this.fluent.getLogFormat(), this.fluent.getLogLevel(), this.fluent.getMinTime(), this.fluent.getObjectStorageConfig(), this.fluent.getResources(), this.fluent.getSha(), this.fluent.getTag(), this.fluent.getTracingConfig(), this.fluent.getVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThanosSpecBuilder that = (ThanosSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

