/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers;

import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.internal.StatefulSetOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class StatefulSetHandler
implements ResourceHandler<StatefulSet, StatefulSetBuilder> {
    @Override
    public String getKind() {
        return StatefulSet.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps/v1";
    }

    @Override
    public StatefulSet create(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new StatefulSet[0]);
    }

    @Override
    public StatefulSet replace(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public StatefulSet reload(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)((Gettable)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public StatefulSetBuilder edit(StatefulSet item) {
        return new StatefulSetBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, StatefulSet item) {
        if (cascading.booleanValue()) {
            return (Boolean)new StatefulSetOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
        }
        return (Boolean)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, Watcher<StatefulSet> watcher) {
        return (Watch)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, String resourceVersion, Watcher<StatefulSet> watcher) {
        return (Watch)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public StatefulSet waitUntilReady(OkHttpClient client, Config config, String namespace, StatefulSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public StatefulSet waitUntilCondition(OkHttpClient client, Config config, String namespace, StatefulSet item, Predicate<StatefulSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

