/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserFluentImpl<A extends UserFluent<A>>
extends BaseFluent<A>
implements UserFluent<A> {
    private String apiVersion;
    private String fullName;
    private List<String> groups;
    private List<String> identities;
    private String kind;
    private ObjectMetaBuilder metadata;

    public UserFluentImpl() {
    }

    public UserFluentImpl(User instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withFullName(instance.getFullName());
        this.withGroups(instance.getGroups());
        this.withIdentities(instance.getIdentities());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public A withFullName(String fullName) {
        this.fullName = fullName;
        return (A)this;
    }

    @Override
    public Boolean hasFullName() {
        return this.fullName != null;
    }

    @Override
    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.groups);
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addToIdentities(int index, String item) {
        if (this.identities == null) {
            this.identities = new ArrayList<String>();
        }
        this.identities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIdentities(int index, String item) {
        this.identities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIdentities(String ... items) {
        for (String item : items) {
            this.identities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIdentities(Collection<String> items) {
        for (String item : items) {
            this.identities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIdentities(String ... items) {
        for (String item : items) {
            if (this.identities == null) continue;
            this.identities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIdentities(Collection<String> items) {
        for (String item : items) {
            if (this.identities == null) continue;
            this.identities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getIdentities() {
        return this.identities;
    }

    @Override
    public String getIdentity(int index) {
        return this.identities.get(index);
    }

    @Override
    public String getFirstIdentity() {
        return this.identities.get(0);
    }

    @Override
    public String getLastIdentity() {
        return this.identities.get(this.identities.size() - 1);
    }

    @Override
    public String getMatchingIdentity(Predicate<String> predicate) {
        for (String item : this.identities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withIdentities(List<String> identities) {
        if (this.identities == null) {
            this.identities = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.identities);
            this.identities.clear();
        }
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIdentities(String ... identities) {
        this.identities.clear();
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIdentities() {
        return this.identities != null && !this.identities.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public UserFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public UserFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public UserFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public UserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserFluentImpl that = (UserFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(that.fullName) : that.fullName != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.identities != null ? !this.identities.equals(that.identities) : that.identities != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<UserFluent.MetadataNested<N>>
    implements UserFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

