/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.NodeSpecFluent;
import io.fabric8.kubernetes.api.model.NodeSpecFluentImpl;

public class NodeSpecBuilder
extends NodeSpecFluentImpl<NodeSpecBuilder>
implements VisitableBuilder<NodeSpec, NodeSpecBuilder> {
    NodeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NodeSpecBuilder() {
        this(true);
    }

    public NodeSpecBuilder(Boolean validationEnabled) {
        this(new NodeSpec(), validationEnabled);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeSpec(), validationEnabled);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, NodeSpec instance) {
        this(fluent, instance, true);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, NodeSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExternalID(instance.getExternalID());
        fluent.withPodCIDR(instance.getPodCIDR());
        fluent.withProviderID(instance.getProviderID());
        fluent.withUnschedulable(instance.getUnschedulable());
        this.validationEnabled = validationEnabled;
    }

    public NodeSpecBuilder(NodeSpec instance) {
        this(instance, (Boolean)true);
    }

    public NodeSpecBuilder(NodeSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withProviderID(instance.getProviderID());
        this.withUnschedulable(instance.getUnschedulable());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeSpec build() {
        NodeSpec buildable = new NodeSpec(this.fluent.getExternalID(), this.fluent.getPodCIDR(), this.fluent.getProviderID(), this.fluent.isUnschedulable());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSpecBuilder that = (NodeSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

