/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class Quantity
implements Serializable {
    private String amount;
    private String format;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Quantity() {
    }

    public Quantity(String amount) {
        Quantity parsedQuantity = Quantity.parse(amount);
        this.amount = parsedQuantity.getAmount();
        this.format = parsedQuantity.getFormat();
    }

    public Quantity(String amount, String format) {
        this.amount = amount;
        this.format = format;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public static BigDecimal getAmountInBytes(Quantity quantity) throws ArithmeticException {
        Quantity amountFormatPair;
        String formatStr;
        String value = "";
        if (quantity.getAmount() != null && quantity.getFormat() != null) {
            value = quantity.getAmount() + quantity.getFormat();
        } else if (quantity.getAmount() != null) {
            value = quantity.getAmount();
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid quantity value passed to parse");
        }
        if (!Character.isDigit(value.indexOf(0)) && value.startsWith(".")) {
            value = "0" + value;
        }
        if (((formatStr = (amountFormatPair = Quantity.parse(value)).getFormat()).startsWith("e") || formatStr.startsWith("E")) && formatStr.length() > 1) {
            int exponent = Integer.parseInt(formatStr.substring(1));
            return new BigDecimal("10").pow(exponent).multiply(new BigDecimal(amountFormatPair.getAmount()));
        }
        BigDecimal digit = new BigDecimal(amountFormatPair.getAmount());
        BigDecimal multiple = new BigDecimal("1");
        BigDecimal binaryFactor = new BigDecimal("2");
        BigDecimal decimalFactor = new BigDecimal("10");
        switch (formatStr) {
            case "Ki": {
                multiple = binaryFactor.pow(10, MathContext.DECIMAL64);
                break;
            }
            case "Mi": {
                multiple = binaryFactor.pow(20, MathContext.DECIMAL64);
                break;
            }
            case "Gi": {
                multiple = binaryFactor.pow(30, MathContext.DECIMAL64);
                break;
            }
            case "Ti": {
                multiple = binaryFactor.pow(40, MathContext.DECIMAL64);
                break;
            }
            case "Pi": {
                multiple = binaryFactor.pow(50, MathContext.DECIMAL64);
                break;
            }
            case "Ei": {
                multiple = binaryFactor.pow(60, MathContext.DECIMAL64);
                break;
            }
            case "n": {
                multiple = decimalFactor.pow(-9, MathContext.DECIMAL64);
                break;
            }
            case "u": {
                multiple = decimalFactor.pow(-6, MathContext.DECIMAL64);
                break;
            }
            case "m": {
                multiple = decimalFactor.pow(-3, MathContext.DECIMAL64);
                break;
            }
            case "k": {
                multiple = decimalFactor.pow(3, MathContext.DECIMAL64);
                break;
            }
            case "M": {
                multiple = decimalFactor.pow(6, MathContext.DECIMAL64);
                break;
            }
            case "G": {
                multiple = decimalFactor.pow(9, MathContext.DECIMAL64);
                break;
            }
            case "T": {
                multiple = decimalFactor.pow(12, MathContext.DECIMAL64);
                break;
            }
            case "P": {
                multiple = decimalFactor.pow(15, MathContext.DECIMAL64);
                break;
            }
            case "E": {
                multiple = decimalFactor.pow(18, MathContext.DECIMAL64);
            }
        }
        return digit.multiply(multiple);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quantity quantity = (Quantity)o;
        return Quantity.getAmountInBytes(this).toBigInteger().equals(Quantity.getAmountInBytes(quantity).toBigInteger());
    }

    public int hashCode() {
        return Quantity.getAmountInBytes(this).toBigInteger().hashCode();
    }

    public static Quantity parse(String quantityAsString) {
        String[] quantityComponents = quantityAsString.split("[eEinumkKMGTP]+");
        if (quantityComponents.length == 0) {
            throw new IllegalArgumentException("Invalid quantity string format passed.");
        }
        String amountStr = quantityComponents[0];
        String formatStr = quantityAsString.substring(quantityComponents[0].length());
        return new Quantity(amountStr, formatStr);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Quantity(amount=" + this.getAmount() + ", format=" + this.getFormat() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public static class Deserializer
    extends JsonDeserializer<Quantity> {
        public Quantity deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Quantity quantity = new Quantity(node.asText());
            return quantity;
        }
    }

    public static class Serializer
    extends JsonSerializer<Quantity> {
        public void serialize(Quantity value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null) {
                StringBuilder objAsStringBuilder = new StringBuilder();
                if (value.getAmount() != null) {
                    objAsStringBuilder.append(value.getAmount());
                }
                if (value.getFormat() != null) {
                    objAsStringBuilder.append(value.getFormat());
                }
                jgen.writeString(objAsStringBuilder.toString());
            } else {
                jgen.writeNull();
            }
        }
    }
}

