package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

public class OpenshiftRoleBindingFluentImpl<A extends OpenshiftRoleBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OpenshiftRoleBindingFluent<A>{

    private String apiVersion;
    private List<String> groupNames = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder roleRef;
    private List<ObjectReferenceBuilder> subjects =  new ArrayList<ObjectReferenceBuilder>();
    private List<String> userNames = new ArrayList<String>();

    public OpenshiftRoleBindingFluentImpl(){
    }
    public OpenshiftRoleBindingFluentImpl(OpenshiftRoleBinding instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withGroupNames(instance.getGroupNames()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
            this.withUserNames(instance.getUserNames()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToGroupNames(int index,String item){
            if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
            this.groupNames.add(index, item);
            return (A)this;
    }

    public A setToGroupNames(int index,String item){
            if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
            this.groupNames.set(index, item); return (A)this;
    }

    public A addToGroupNames(String... items){
            if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
            for (String item : items) {this.groupNames.add(item);} return (A)this;
    }

    public A addAllToGroupNames(Collection<String> items){
            if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
            for (String item : items) {this.groupNames.add(item);} return (A)this;
    }

    public A removeFromGroupNames(String... items){
            for (String item : items) {if (this.groupNames!= null){ this.groupNames.remove(item);}} return (A)this;
    }

    public A removeAllFromGroupNames(Collection<String> items){
            for (String item : items) {if (this.groupNames!= null){ this.groupNames.remove(item);}} return (A)this;
    }

    public List<String> getGroupNames(){
            return this.groupNames;
    }

    public String getGroupName(int index){
            return this.groupNames.get(index);
    }

    public String getFirstGroupName(){
            return this.groupNames.get(0);
    }

    public String getLastGroupName(){
            return this.groupNames.get(groupNames.size() - 1);
    }

    public String getMatchingGroupName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: groupNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGroupName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: groupNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGroupNames(List<String> groupNames){
            if (this.groupNames != null) { _visitables.get("groupNames").removeAll(this.groupNames);}
            if (groupNames != null) {this.groupNames = new ArrayList<String>(); for (String item : groupNames){this.addToGroupNames(item);}} else { this.groupNames = null;} return (A) this;
    }

    public A withGroupNames(String... groupNames){
            if (this.groupNames != null) {this.groupNames.clear();}
            if (groupNames != null) {for (String item :groupNames){ this.addToGroupNames(item);}} return (A) this;
    }

    public Boolean hasGroupNames(){
            return groupNames != null && !groupNames.isEmpty();
    }

    public A addNewGroupName(String arg1){
            return (A)addToGroupNames(new String(arg1));
    }

    public A addNewGroupName(StringBuilder arg1){
            return (A)addToGroupNames(new String(arg1));
    }

    public A addNewGroupName(StringBuffer arg1){
            return (A)addToGroupNames(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public OpenshiftRoleBindingFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public OpenshiftRoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public OpenshiftRoleBindingFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public OpenshiftRoleBindingFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public OpenshiftRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRoleRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getRoleRef(){
            return this.roleRef!=null?this.roleRef.build():null;
    }

    public ObjectReference buildRoleRef(){
            return this.roleRef!=null?this.roleRef.build():null;
    }

    public A withRoleRef(ObjectReference roleRef){
            _visitables.get("roleRef").remove(this.roleRef);
            if (roleRef!=null){ this.roleRef= new ObjectReferenceBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} return (A) this;
    }

    public Boolean hasRoleRef(){
            return this.roleRef != null;
    }

    public OpenshiftRoleBindingFluent.RoleRefNested<A> withNewRoleRef(){
            return new RoleRefNestedImpl();
    }

    public OpenshiftRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item){
            return new RoleRefNestedImpl(item);
    }

    public OpenshiftRoleBindingFluent.RoleRefNested<A> editRoleRef(){
            return withNewRoleRefLike(getRoleRef());
    }

    public OpenshiftRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef(){
            return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): new ObjectReferenceBuilder().build());
    }

    public OpenshiftRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item){
            return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): item);
    }

    public A addToSubjects(int index,ObjectReference item){
            if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(index >= 0 ? index : _visitables.get("subjects").size(), builder);this.subjects.add(index >= 0 ? index : subjects.size(), builder); return (A)this;
    }

    public A setToSubjects(int index,ObjectReference item){
            if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            if (index < 0 || index >= _visitables.get("subjects").size()) { _visitables.get("subjects").add(builder); } else { _visitables.get("subjects").set(index, builder);}
            if (index < 0 || index >= subjects.size()) { subjects.add(builder); } else { subjects.set(index, builder);}
             return (A)this;
    }

    public A addToSubjects(ObjectReference... items){
            if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
            for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
    }

    public A addAllToSubjects(Collection<ObjectReference> items){
            if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
            for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
    }

    public A removeFromSubjects(ObjectReference... items){
            for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubjects(Collection<ObjectReference> items){
            for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubjects(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate){
            if (subjects == null) return (A) this;
            final Iterator<ObjectReferenceBuilder> each = subjects.iterator();
            final List visitables = _visitables.get("subjects");
            while (each.hasNext()) {
              ObjectReferenceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubjects instead.
 * @return The buildable object.
 */
@Deprecated public List<ObjectReference> getSubjects(){
            return build(subjects);
    }

    public List<ObjectReference> buildSubjects(){
            return build(subjects);
    }

    public ObjectReference buildSubject(int index){
            return this.subjects.get(index).build();
    }

    public ObjectReference buildFirstSubject(){
            return this.subjects.get(0).build();
    }

    public ObjectReference buildLastSubject(){
            return this.subjects.get(subjects.size() - 1).build();
    }

    public ObjectReference buildMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate){
            for (ObjectReferenceBuilder item: subjects) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate){
            for (ObjectReferenceBuilder item: subjects) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubjects(List<ObjectReference> subjects){
            if (this.subjects != null) { _visitables.get("subjects").removeAll(this.subjects);}
            if (subjects != null) {this.subjects = new ArrayList<ObjectReferenceBuilder>(); for (ObjectReference item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
    }

    public A withSubjects(ObjectReference... subjects){
            if (this.subjects != null) {this.subjects.clear();}
            if (subjects != null) {for (ObjectReference item :subjects){ this.addToSubjects(item);}} return (A) this;
    }

    public Boolean hasSubjects(){
            return subjects != null && !subjects.isEmpty();
    }

    public OpenshiftRoleBindingFluent.SubjectsNested<A> addNewSubject(){
            return new SubjectsNestedImpl();
    }

    public OpenshiftRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item){
            return new SubjectsNestedImpl(-1, item);
    }

    public OpenshiftRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index,ObjectReference item){
            return new SubjectsNestedImpl(index, item);
    }

    public OpenshiftRoleBindingFluent.SubjectsNested<A> editSubject(int index){
            if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public OpenshiftRoleBindingFluent.SubjectsNested<A> editFirstSubject(){
            if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
            return setNewSubjectLike(0, buildSubject(0));
    }

    public OpenshiftRoleBindingFluent.SubjectsNested<A> editLastSubject(){
            int index = subjects.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public OpenshiftRoleBindingFluent.SubjectsNested<A> editMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate){
            int index = -1;
            for (int i=0;i<subjects.size();i++) { 
            if (predicate.apply(subjects.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public A addToUserNames(int index,String item){
            if (this.userNames == null) {this.userNames = new ArrayList<String>();}
            this.userNames.add(index, item);
            return (A)this;
    }

    public A setToUserNames(int index,String item){
            if (this.userNames == null) {this.userNames = new ArrayList<String>();}
            this.userNames.set(index, item); return (A)this;
    }

    public A addToUserNames(String... items){
            if (this.userNames == null) {this.userNames = new ArrayList<String>();}
            for (String item : items) {this.userNames.add(item);} return (A)this;
    }

    public A addAllToUserNames(Collection<String> items){
            if (this.userNames == null) {this.userNames = new ArrayList<String>();}
            for (String item : items) {this.userNames.add(item);} return (A)this;
    }

    public A removeFromUserNames(String... items){
            for (String item : items) {if (this.userNames!= null){ this.userNames.remove(item);}} return (A)this;
    }

    public A removeAllFromUserNames(Collection<String> items){
            for (String item : items) {if (this.userNames!= null){ this.userNames.remove(item);}} return (A)this;
    }

    public List<String> getUserNames(){
            return this.userNames;
    }

    public String getUserName(int index){
            return this.userNames.get(index);
    }

    public String getFirstUserName(){
            return this.userNames.get(0);
    }

    public String getLastUserName(){
            return this.userNames.get(userNames.size() - 1);
    }

    public String getMatchingUserName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: userNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingUserName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: userNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withUserNames(List<String> userNames){
            if (this.userNames != null) { _visitables.get("userNames").removeAll(this.userNames);}
            if (userNames != null) {this.userNames = new ArrayList<String>(); for (String item : userNames){this.addToUserNames(item);}} else { this.userNames = null;} return (A) this;
    }

    public A withUserNames(String... userNames){
            if (this.userNames != null) {this.userNames.clear();}
            if (userNames != null) {for (String item :userNames){ this.addToUserNames(item);}} return (A) this;
    }

    public Boolean hasUserNames(){
            return userNames != null && !userNames.isEmpty();
    }

    public A addNewUserName(String arg1){
            return (A)addToUserNames(new String(arg1));
    }

    public A addNewUserName(StringBuilder arg1){
            return (A)addToUserNames(new String(arg1));
    }

    public A addNewUserName(StringBuffer arg1){
            return (A)addToUserNames(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            OpenshiftRoleBindingFluentImpl that = (OpenshiftRoleBindingFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (groupNames != null ? !groupNames.equals(that.groupNames) :that.groupNames != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
            if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
            if (userNames != null ? !userNames.equals(that.userNames) :that.userNames != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<OpenshiftRoleBindingFluent.MetadataNested<N>> implements OpenshiftRoleBindingFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) OpenshiftRoleBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RoleRefNestedImpl<N> extends ObjectReferenceFluentImpl<OpenshiftRoleBindingFluent.RoleRefNested<N>> implements OpenshiftRoleBindingFluent.RoleRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            RoleRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            RoleRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) OpenshiftRoleBindingFluentImpl.this.withRoleRef(builder.build());
    }
    public N endRoleRef(){
            return and();
    }

}
    public class SubjectsNestedImpl<N> extends ObjectReferenceFluentImpl<OpenshiftRoleBindingFluent.SubjectsNested<N>> implements OpenshiftRoleBindingFluent.SubjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
        private final int index;
    
            SubjectsNestedImpl(int index,ObjectReference item){
                    this.index = index;
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            SubjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) OpenshiftRoleBindingFluentImpl.this.setToSubjects(index,builder.build());
    }
    public N endSubject(){
            return and();
    }

}


}
