package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesRunAsUserStrategyOptionsBuilder extends KubernetesRunAsUserStrategyOptionsFluentImpl<KubernetesRunAsUserStrategyOptionsBuilder> implements VisitableBuilder<KubernetesRunAsUserStrategyOptions,KubernetesRunAsUserStrategyOptionsBuilder>{

    KubernetesRunAsUserStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesRunAsUserStrategyOptionsBuilder(){
            this(true);
    }
    public KubernetesRunAsUserStrategyOptionsBuilder(Boolean validationEnabled){
            this(new KubernetesRunAsUserStrategyOptions(), validationEnabled);
    }
    public KubernetesRunAsUserStrategyOptionsBuilder(KubernetesRunAsUserStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesRunAsUserStrategyOptionsBuilder(KubernetesRunAsUserStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesRunAsUserStrategyOptions(), validationEnabled);
    }
    public KubernetesRunAsUserStrategyOptionsBuilder(KubernetesRunAsUserStrategyOptionsFluent<?> fluent,KubernetesRunAsUserStrategyOptions instance){
            this(fluent, instance, true);
    }
    public KubernetesRunAsUserStrategyOptionsBuilder(KubernetesRunAsUserStrategyOptionsFluent<?> fluent,KubernetesRunAsUserStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges()); 
            fluent.withRule(instance.getRule()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRunAsUserStrategyOptionsBuilder(KubernetesRunAsUserStrategyOptions instance){
            this(instance,true);
    }
    public KubernetesRunAsUserStrategyOptionsBuilder(KubernetesRunAsUserStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges()); 
            this.withRule(instance.getRule()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesRunAsUserStrategyOptions build(){
            KubernetesRunAsUserStrategyOptions buildable = new KubernetesRunAsUserStrategyOptions(fluent.getRanges(),fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesRunAsUserStrategyOptionsBuilder that = (KubernetesRunAsUserStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
