package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ComponentConditionFluentImpl<A extends ComponentConditionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ComponentConditionFluent<A>{

    private String error;
    private String message;
    private String status;
    private String type;

    public ComponentConditionFluentImpl(){
    }
    public ComponentConditionFluentImpl(ComponentCondition instance){
            this.withError(instance.getError()); 
            this.withMessage(instance.getMessage()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
    }

    public String getError(){
            return this.error;
    }

    public A withError(String error){
            this.error=error; return (A) this;
    }

    public Boolean hasError(){
            return this.error != null;
    }

    public A withNewError(String arg1){
            return (A)withError(new String(arg1));
    }

    public A withNewError(StringBuilder arg1){
            return (A)withError(new String(arg1));
    }

    public A withNewError(StringBuffer arg1){
            return (A)withError(new String(arg1));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public A withNewStatus(String arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1){
            return (A)withStatus(new String(arg1));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ComponentConditionFluentImpl that = (ComponentConditionFluentImpl) o;
            if (error != null ? !error.equals(that.error) :that.error != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
