package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LeaseBuilder extends LeaseFluentImpl<LeaseBuilder> implements VisitableBuilder<Lease,LeaseBuilder>{

    LeaseFluent<?> fluent;
    Boolean validationEnabled;

    public LeaseBuilder(){
            this(true);
    }
    public LeaseBuilder(Boolean validationEnabled){
            this(new Lease(), validationEnabled);
    }
    public LeaseBuilder(LeaseFluent<?> fluent){
            this(fluent, true);
    }
    public LeaseBuilder(LeaseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Lease(), validationEnabled);
    }
    public LeaseBuilder(LeaseFluent<?> fluent,Lease instance){
            this(fluent, instance, true);
    }
    public LeaseBuilder(LeaseFluent<?> fluent,Lease instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public LeaseBuilder(Lease instance){
            this(instance,true);
    }
    public LeaseBuilder(Lease instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Lease build(){
            Lease buildable = new Lease(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LeaseBuilder that = (LeaseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
