/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LimitRangeSpec;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluent;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluentImpl;
import javax.validation.Validator;

public class LimitRangeSpecBuilder
extends LimitRangeSpecFluentImpl<LimitRangeSpecBuilder>
implements VisitableBuilder<LimitRangeSpec, LimitRangeSpecBuilder> {
    LimitRangeSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LimitRangeSpecBuilder() {
        this(true);
    }

    public LimitRangeSpecBuilder(Boolean validationEnabled) {
        this(new LimitRangeSpec(), validationEnabled);
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LimitRangeSpec(), validationEnabled);
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent, LimitRangeSpec instance) {
        this(fluent, instance, true);
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent, LimitRangeSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
        this.validationEnabled = validationEnabled;
    }

    public LimitRangeSpecBuilder(LimitRangeSpec instance) {
        this(instance, (Boolean)true);
    }

    public LimitRangeSpecBuilder(LimitRangeSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
        this.validationEnabled = validationEnabled;
    }

    public LimitRangeSpecBuilder(Validator validator) {
        this(new LimitRangeSpec(), (Boolean)true);
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent, LimitRangeSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public LimitRangeSpecBuilder(LimitRangeSpec instance, Validator validator) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public LimitRangeSpec build() {
        LimitRangeSpec buildable = new LimitRangeSpec(this.fluent.getLimits());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeSpecBuilder that = (LimitRangeSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

