/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.version;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.kubernetes.api.model.version.InfoFluent;
import io.fabric8.kubernetes.api.model.version.InfoFluentImpl;
import javax.validation.Validator;

public class InfoBuilder
extends InfoFluentImpl<InfoBuilder>
implements VisitableBuilder<Info, InfoBuilder> {
    InfoFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public InfoBuilder() {
        this(true);
    }

    public InfoBuilder(Boolean validationEnabled) {
        this(new Info(), validationEnabled);
    }

    public InfoBuilder(InfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InfoBuilder(InfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Info(), validationEnabled);
    }

    public InfoBuilder(InfoFluent<?> fluent, Info instance) {
        this(fluent, instance, true);
    }

    public InfoBuilder(InfoFluent<?> fluent, Info instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBuildDate(instance.getBuildDate());
        fluent.withCompiler(instance.getCompiler());
        fluent.withGitCommit(instance.getGitCommit());
        fluent.withGitTreeState(instance.getGitTreeState());
        fluent.withGitVersion(instance.getGitVersion());
        fluent.withGoVersion(instance.getGoVersion());
        fluent.withMajor(instance.getMajor());
        fluent.withMinor(instance.getMinor());
        fluent.withPlatform(instance.getPlatform());
        this.validationEnabled = validationEnabled;
    }

    public InfoBuilder(Info instance) {
        this(instance, (Boolean)true);
    }

    public InfoBuilder(Info instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBuildDate(instance.getBuildDate());
        this.withCompiler(instance.getCompiler());
        this.withGitCommit(instance.getGitCommit());
        this.withGitTreeState(instance.getGitTreeState());
        this.withGitVersion(instance.getGitVersion());
        this.withGoVersion(instance.getGoVersion());
        this.withMajor(instance.getMajor());
        this.withMinor(instance.getMinor());
        this.withPlatform(instance.getPlatform());
        this.validationEnabled = validationEnabled;
    }

    public InfoBuilder(Validator validator) {
        this(new Info(), (Boolean)true);
    }

    public InfoBuilder(InfoFluent<?> fluent, Info instance, Validator validator) {
        this.fluent = fluent;
        fluent.withBuildDate(instance.getBuildDate());
        fluent.withCompiler(instance.getCompiler());
        fluent.withGitCommit(instance.getGitCommit());
        fluent.withGitTreeState(instance.getGitTreeState());
        fluent.withGitVersion(instance.getGitVersion());
        fluent.withGoVersion(instance.getGoVersion());
        fluent.withMajor(instance.getMajor());
        fluent.withMinor(instance.getMinor());
        fluent.withPlatform(instance.getPlatform());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public InfoBuilder(Info instance, Validator validator) {
        this.fluent = this;
        this.withBuildDate(instance.getBuildDate());
        this.withCompiler(instance.getCompiler());
        this.withGitCommit(instance.getGitCommit());
        this.withGitTreeState(instance.getGitTreeState());
        this.withGitVersion(instance.getGitVersion());
        this.withGoVersion(instance.getGoVersion());
        this.withMajor(instance.getMajor());
        this.withMinor(instance.getMinor());
        this.withPlatform(instance.getPlatform());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Info build() {
        Info buildable = new Info(this.fluent.getBuildDate(), this.fluent.getCompiler(), this.fluent.getGitCommit(), this.fluent.getGitTreeState(), this.fluent.getGitVersion(), this.fluent.getGoVersion(), this.fluent.getMajor(), this.fluent.getMinor(), this.fluent.getPlatform());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfoBuilder that = (InfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

