/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRule;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRuleFluentImpl;
import javax.validation.Validator;

public class NetworkPolicyIngressRuleBuilder
extends NetworkPolicyIngressRuleFluentImpl<NetworkPolicyIngressRuleBuilder>
implements VisitableBuilder<NetworkPolicyIngressRule, NetworkPolicyIngressRuleBuilder> {
    NetworkPolicyIngressRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NetworkPolicyIngressRuleBuilder() {
        this(true);
    }

    public NetworkPolicyIngressRuleBuilder(Boolean validationEnabled) {
        this(new NetworkPolicyIngressRule(), validationEnabled);
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicyIngressRule(), validationEnabled);
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent, NetworkPolicyIngressRule instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent, NetworkPolicyIngressRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFrom(instance.getFrom());
        fluent.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRule instance) {
        this(instance, (Boolean)true);
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFrom(instance.getFrom());
        this.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyIngressRuleBuilder(Validator validator) {
        this(new NetworkPolicyIngressRule(), (Boolean)true);
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRuleFluent<?> fluent, NetworkPolicyIngressRule instance, Validator validator) {
        this.fluent = fluent;
        fluent.withFrom(instance.getFrom());
        fluent.withPorts(instance.getPorts());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NetworkPolicyIngressRuleBuilder(NetworkPolicyIngressRule instance, Validator validator) {
        this.fluent = this;
        this.withFrom(instance.getFrom());
        this.withPorts(instance.getPorts());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NetworkPolicyIngressRule build() {
        NetworkPolicyIngressRule buildable = new NetworkPolicyIngressRule(this.fluent.getFrom(), this.fluent.getPorts());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyIngressRuleBuilder that = (NetworkPolicyIngressRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

