/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FCVolumeSourceFluentImpl<A extends FCVolumeSourceFluent<A>>
extends BaseFluent<A>
implements FCVolumeSourceFluent<A> {
    private String fsType;
    private Integer lun;
    private Boolean readOnly;
    private List<String> targetWWNs;
    private List<String> wwids;

    public FCVolumeSourceFluentImpl() {
    }

    public FCVolumeSourceFluentImpl(FCVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withLun(instance.getLun());
        this.withReadOnly(instance.getReadOnly());
        this.withTargetWWNs(instance.getTargetWWNs());
        this.withWwids(instance.getWwids());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    @Override
    public Boolean hasLun() {
        return this.lun != null;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A addToTargetWWNs(int index, String item) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTargetWWNs(int index, String item) {
        this.targetWWNs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTargetWWNs(String ... items) {
        for (String item : items) {
            this.targetWWNs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTargetWWNs(Collection<String> items) {
        for (String item : items) {
            this.targetWWNs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTargetWWNs(String ... items) {
        for (String item : items) {
            if (this.targetWWNs == null) continue;
            this.targetWWNs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTargetWWNs(Collection<String> items) {
        for (String item : items) {
            if (this.targetWWNs == null) continue;
            this.targetWWNs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    @Override
    public String getTargetWWN(int index) {
        return this.targetWWNs.get(index);
    }

    @Override
    public String getFirstTargetWWN() {
        return this.targetWWNs.get(0);
    }

    @Override
    public String getLastTargetWWN() {
        return this.targetWWNs.get(this.targetWWNs.size() - 1);
    }

    @Override
    public String getMatchingTargetWWN(Predicate<String> predicate) {
        for (String item : this.targetWWNs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withTargetWWNs(List<String> targetWWNs) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.targetWWNs);
            this.targetWWNs.clear();
        }
        if (targetWWNs != null) {
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTargetWWNs(String ... targetWWNs) {
        this.targetWWNs.clear();
        if (targetWWNs != null) {
            for (String item : targetWWNs) {
                this.addToTargetWWNs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetWWNs() {
        return this.targetWWNs != null && !this.targetWWNs.isEmpty();
    }

    @Override
    public A addToWwids(int index, String item) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.add(index, item);
        return (A)this;
    }

    @Override
    public A setToWwids(int index, String item) {
        this.wwids.set(index, item);
        return (A)this;
    }

    @Override
    public A addToWwids(String ... items) {
        for (String item : items) {
            this.wwids.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToWwids(Collection<String> items) {
        for (String item : items) {
            this.wwids.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromWwids(String ... items) {
        for (String item : items) {
            if (this.wwids == null) continue;
            this.wwids.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWwids(Collection<String> items) {
        for (String item : items) {
            if (this.wwids == null) continue;
            this.wwids.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getWwids() {
        return this.wwids;
    }

    @Override
    public String getWwid(int index) {
        return this.wwids.get(index);
    }

    @Override
    public String getFirstWwid() {
        return this.wwids.get(0);
    }

    @Override
    public String getLastWwid() {
        return this.wwids.get(this.wwids.size() - 1);
    }

    @Override
    public String getMatchingWwid(Predicate<String> predicate) {
        for (String item : this.wwids) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withWwids(List<String> wwids) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.wwids);
            this.wwids.clear();
        }
        if (wwids != null) {
            for (String item : wwids) {
                this.addToWwids(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withWwids(String ... wwids) {
        this.wwids.clear();
        if (wwids != null) {
            for (String item : wwids) {
                this.addToWwids(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWwids() {
        return this.wwids != null && !this.wwids.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FCVolumeSourceFluentImpl that = (FCVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.lun != null ? !this.lun.equals(that.lun) : that.lun != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.targetWWNs != null ? !this.targetWWNs.equals(that.targetWWNs) : that.targetWWNs != null) {
            return false;
        }
        return !(this.wwids != null ? !this.wwids.equals(that.wwids) : that.wwids != null);
    }
}

