/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeFluent;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;

public class TimeBuilder
extends TimeFluentImpl<TimeBuilder>
implements VisitableBuilder<Time, TimeBuilder> {
    TimeFluent<?> fluent;
    Boolean validationEnabled;

    public TimeBuilder() {
        this(true);
    }

    public TimeBuilder(Boolean validationEnabled) {
        this(new Time(), validationEnabled);
    }

    public TimeBuilder(TimeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TimeBuilder(TimeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Time(), validationEnabled);
    }

    public TimeBuilder(TimeFluent<?> fluent, Time instance) {
        this(fluent, instance, true);
    }

    public TimeBuilder(TimeFluent<?> fluent, Time instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTime(instance.getTime());
        this.validationEnabled = validationEnabled;
    }

    public TimeBuilder(Time instance) {
        this(instance, (Boolean)true);
    }

    public TimeBuilder(Time instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTime(instance.getTime());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Time build() {
        Time buildable = new Time(this.fluent.getTime());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeBuilder that = (TimeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

