/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.SignatureIssuer;
import io.fabric8.openshift.api.model.SignatureIssuerFluent;
import io.fabric8.openshift.api.model.SignatureIssuerFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SignatureIssuerBuilder
extends SignatureIssuerFluentImpl<SignatureIssuerBuilder>
implements VisitableBuilder<SignatureIssuer, SignatureIssuerBuilder> {
    SignatureIssuerFluent<?> fluent;
    Boolean validationEnabled;

    public SignatureIssuerBuilder() {
        this(true);
    }

    public SignatureIssuerBuilder(Boolean validationEnabled) {
        this(new SignatureIssuer(), validationEnabled);
    }

    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SignatureIssuer(), validationEnabled);
    }

    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent, SignatureIssuer instance) {
        this(fluent, instance, true);
    }

    public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent, SignatureIssuer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCommonName(instance.getCommonName());
        fluent.withOrganization(instance.getOrganization());
        this.validationEnabled = validationEnabled;
    }

    public SignatureIssuerBuilder(SignatureIssuer instance) {
        this(instance, (Boolean)true);
    }

    public SignatureIssuerBuilder(SignatureIssuer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCommonName(instance.getCommonName());
        this.withOrganization(instance.getOrganization());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SignatureIssuer build() {
        SignatureIssuer buildable = new SignatureIssuer(this.fluent.getCommonName(), this.fluent.getOrganization());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SignatureIssuerBuilder that = (SignatureIssuerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

