/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathFluent;
import io.fabric8.openshift.api.model.ImageSourcePathFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageSourcePathBuilder
extends ImageSourcePathFluentImpl<ImageSourcePathBuilder>
implements VisitableBuilder<ImageSourcePath, ImageSourcePathBuilder> {
    ImageSourcePathFluent<?> fluent;
    Boolean validationEnabled;

    public ImageSourcePathBuilder() {
        this(true);
    }

    public ImageSourcePathBuilder(Boolean validationEnabled) {
        this(new ImageSourcePath(), validationEnabled);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageSourcePath(), validationEnabled);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, ImageSourcePath instance) {
        this(fluent, instance, true);
    }

    public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent, ImageSourcePath instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSourcePath(instance.getSourcePath());
        this.validationEnabled = validationEnabled;
    }

    public ImageSourcePathBuilder(ImageSourcePath instance) {
        this(instance, (Boolean)true);
    }

    public ImageSourcePathBuilder(ImageSourcePath instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSourcePath(instance.getSourcePath());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ImageSourcePath build() {
        ImageSourcePath buildable = new ImageSourcePath(this.fluent.getDestinationDir(), this.fluent.getSourcePath());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourcePathBuilder that = (ImageSourcePathBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

