/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageLayer;
import io.fabric8.openshift.api.model.ImageLayerFluent;
import io.fabric8.openshift.api.model.ImageLayerFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageLayerBuilder
extends ImageLayerFluentImpl<ImageLayerBuilder>
implements VisitableBuilder<ImageLayer, ImageLayerBuilder> {
    ImageLayerFluent<?> fluent;

    public ImageLayerBuilder() {
        this(new ImageLayer());
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent) {
        this(fluent, new ImageLayer());
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, ImageLayer instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withSize(instance.getSize());
    }

    public ImageLayerBuilder(ImageLayer instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withSize(instance.getSize());
    }

    @Override
    public ImageLayer build() {
        ImageLayer buildable = new ImageLayer(this.fluent.getName(), this.fluent.getSize());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageLayerBuilder that = (ImageLayerBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

