/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentSpecBuilder
extends DeploymentSpecFluentImpl<DeploymentSpecBuilder>
implements VisitableBuilder<DeploymentSpec, DeploymentSpecBuilder> {
    DeploymentSpecFluent<?> fluent;

    public DeploymentSpecBuilder() {
        this(new DeploymentSpec());
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent) {
        this(fluent, new DeploymentSpec());
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, DeploymentSpec instance) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withPaused(instance.getPaused());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withRollbackTo(instance.getRollbackTo());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
    }

    public DeploymentSpecBuilder(DeploymentSpec instance) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withRollbackTo(instance.getRollbackTo());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public DeploymentSpec build() {
        DeploymentSpec buildable = new DeploymentSpec(this.fluent.getMinReadySeconds(), this.fluent.isPaused(), this.fluent.getReplicas(), this.fluent.getRevisionHistoryLimit(), this.fluent.getRollbackTo(), this.fluent.getSelector(), this.fluent.getStrategy(), this.fluent.getTemplate());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentSpecBuilder that = (DeploymentSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

