/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluent;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigMapKeySelectorBuilder
extends ConfigMapKeySelectorFluentImpl<ConfigMapKeySelectorBuilder>
implements VisitableBuilder<ConfigMapKeySelector, ConfigMapKeySelectorBuilder> {
    ConfigMapKeySelectorFluent<?> fluent;

    public ConfigMapKeySelectorBuilder() {
        this(new ConfigMapKeySelector());
    }

    public ConfigMapKeySelectorBuilder(ConfigMapKeySelectorFluent<?> fluent) {
        this(fluent, new ConfigMapKeySelector());
    }

    public ConfigMapKeySelectorBuilder(ConfigMapKeySelectorFluent<?> fluent, ConfigMapKeySelector instance) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withName(instance.getName());
    }

    public ConfigMapKeySelectorBuilder(ConfigMapKeySelector instance) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withName(instance.getName());
    }

    @Override
    public ConfigMapKeySelector build() {
        ConfigMapKeySelector buildable = new ConfigMapKeySelector(this.fluent.getKey(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapKeySelectorBuilder that = (ConfigMapKeySelectorBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

