/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackFluent;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigBuilder;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class DeploymentRollbackFluentImpl<T extends DeploymentRollbackFluent<T>>
extends BaseFluent<T>
implements DeploymentRollbackFluent<T> {
    String apiVersion;
    String kind;
    String name;
    VisitableBuilder<RollbackConfig, ?> rollbackTo;
    Map<String, String> updatedAnnotations = new HashMap<String, String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public DeploymentRollbackFluentImpl() {
    }

    public DeploymentRollbackFluentImpl(DeploymentRollback instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRollbackTo(instance.getRollbackTo());
        this.withUpdatedAnnotations(instance.getUpdatedAnnotations());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public RollbackConfig getRollbackTo() {
        return this.rollbackTo != null ? (RollbackConfig)this.rollbackTo.build() : null;
    }

    @Override
    public T withRollbackTo(RollbackConfig rollbackTo) {
        if (rollbackTo != null) {
            this.rollbackTo = new RollbackConfigBuilder(rollbackTo);
            this._visitables.add(this.rollbackTo);
        }
        return (T)this;
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<T> withNewRollbackTo() {
        return new RollbackToNestedImpl();
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<T> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNestedImpl(item);
    }

    @Override
    public DeploymentRollbackFluent.RollbackToNested<T> editRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo());
    }

    @Override
    public T withNewRollbackTo(Long revision) {
        return this.withRollbackTo(new RollbackConfig(revision));
    }

    @Override
    public T addToUpdatedAnnotations(String key, String value) {
        if (key != null && value != null) {
            this.updatedAnnotations.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToUpdatedAnnotations(Map<String, String> map) {
        if (map != null) {
            this.updatedAnnotations.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromUpdatedAnnotations(String key) {
        if (key != null) {
            this.updatedAnnotations.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromUpdatedAnnotations(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.updatedAnnotations.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getUpdatedAnnotations() {
        return this.updatedAnnotations;
    }

    @Override
    public T withUpdatedAnnotations(Map<String, String> updatedAnnotations) {
        this.updatedAnnotations.clear();
        if (updatedAnnotations != null) {
            this.updatedAnnotations.putAll(updatedAnnotations);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentRollbackFluentImpl that = (DeploymentRollbackFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.rollbackTo != null ? !this.rollbackTo.equals(that.rollbackTo) : that.rollbackTo != null) {
            return false;
        }
        if (this.updatedAnnotations != null ? !this.updatedAnnotations.equals(that.updatedAnnotations) : that.updatedAnnotations != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RollbackToNestedImpl<N>
    extends RollbackConfigFluentImpl<DeploymentRollbackFluent.RollbackToNested<N>>
    implements DeploymentRollbackFluent.RollbackToNested<N> {
        private final RollbackConfigBuilder builder;

        RollbackToNestedImpl() {
            this.builder = new RollbackConfigBuilder(this);
        }

        RollbackToNestedImpl(RollbackConfig item) {
            this.builder = new RollbackConfigBuilder(this, item);
        }

        @Override
        public N endRollbackTo() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentRollbackFluentImpl.this.withRollbackTo(this.builder.build());
        }
    }
}

