/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServicePortFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSpecFluentImpl<T extends ServiceSpecFluent<T>>
extends BaseFluent<T>
implements ServiceSpecFluent<T> {
    String clusterIP;
    List<String> deprecatedPublicIPs = new ArrayList<String>();
    List<String> externalIPs = new ArrayList<String>();
    String loadBalancerIP;
    String portalIP;
    List<VisitableBuilder<ServicePort, ?>> ports = new ArrayList();
    Map<String, String> selector = new HashMap<String, String>();
    String sessionAffinity;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ServiceSpecFluentImpl() {
    }

    public ServiceSpecFluentImpl(ServiceSpec instance) {
        this.withClusterIP(instance.getClusterIP());
        this.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs());
        this.withExternalIPs(instance.getExternalIPs());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withPortalIP(instance.getPortalIP());
        this.withPorts(instance.getPorts());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withType(instance.getType());
    }

    @Override
    public String getClusterIP() {
        return this.clusterIP;
    }

    @Override
    public T withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (T)this;
    }

    @Override
    public T addToDeprecatedPublicIPs(String ... items) {
        for (String item : items) {
            this.deprecatedPublicIPs.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromDeprecatedPublicIPs(String ... items) {
        for (String item : items) {
            this.deprecatedPublicIPs.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getDeprecatedPublicIPs() {
        return this.deprecatedPublicIPs;
    }

    @Override
    public T withDeprecatedPublicIPs(List<String> deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withDeprecatedPublicIPs(String ... deprecatedPublicIPs) {
        this.deprecatedPublicIPs.clear();
        if (deprecatedPublicIPs != null) {
            for (String item : deprecatedPublicIPs) {
                this.addToDeprecatedPublicIPs(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToExternalIPs(String ... items) {
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromExternalIPs(String ... items) {
        for (String item : items) {
            this.externalIPs.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    @Override
    public T withExternalIPs(List<String> externalIPs) {
        this.externalIPs.clear();
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withExternalIPs(String ... externalIPs) {
        this.externalIPs.clear();
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    @Override
    public T withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (T)this;
    }

    @Override
    public String getPortalIP() {
        return this.portalIP;
    }

    @Override
    public T withPortalIP(String portalIP) {
        this.portalIP = portalIP;
        return (T)this;
    }

    @Override
    public T addToPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ServicePort> getPorts() {
        return this.build(this.ports);
    }

    @Override
    public T withPorts(List<ServicePort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withPorts(ServicePort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public ServiceSpecFluent.PortsNested<T> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ServiceSpecFluent.PortsNested<T> addNewPortLike(ServicePort item) {
        return new PortsNestedImpl(item);
    }

    @Override
    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)this;
    }

    @Override
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    @Override
    public T withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (T)this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecFluentImpl that = (ServiceSpecFluentImpl)o;
        if (this.clusterIP != null ? !this.clusterIP.equals(that.clusterIP) : that.clusterIP != null) {
            return false;
        }
        if (this.deprecatedPublicIPs != null ? !this.deprecatedPublicIPs.equals(that.deprecatedPublicIPs) : that.deprecatedPublicIPs != null) {
            return false;
        }
        if (this.externalIPs != null ? !this.externalIPs.equals(that.externalIPs) : that.externalIPs != null) {
            return false;
        }
        if (this.loadBalancerIP != null ? !this.loadBalancerIP.equals(that.loadBalancerIP) : that.loadBalancerIP != null) {
            return false;
        }
        if (this.portalIP != null ? !this.portalIP.equals(that.portalIP) : that.portalIP != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.sessionAffinity != null ? !this.sessionAffinity.equals(that.sessionAffinity) : that.sessionAffinity != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class PortsNestedImpl<N>
    extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>>
    implements ServiceSpecFluent.PortsNested<N> {
        private final ServicePortBuilder builder;

        PortsNestedImpl() {
            this.builder = new ServicePortBuilder(this);
        }

        PortsNestedImpl(ServicePort item) {
            this.builder = new ServicePortBuilder(this, item);
        }

        @Override
        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.addToPorts(this.builder.build());
        }
    }
}

