/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.EditableContainerStatus;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStatusBuilder
extends ContainerStatusFluentImpl<ContainerStatusBuilder>
implements VisitableBuilder<ContainerStatus, ContainerStatusBuilder> {
    ContainerStatusFluent<?> fluent;

    public ContainerStatusBuilder() {
        this(new ContainerStatus());
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
        this(fluent, new ContainerStatus());
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance) {
        this.fluent = fluent;
        fluent.withContainerID(instance.getContainerID());
        fluent.withImage(instance.getImage());
        fluent.withImageID(instance.getImageID());
        fluent.withLastState(instance.getLastState());
        fluent.withName(instance.getName());
        fluent.withReady(instance.getReady());
        fluent.withRestartCount(instance.getRestartCount());
        fluent.withState(instance.getState());
    }

    public ContainerStatusBuilder(ContainerStatus instance) {
        this.fluent = this;
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withImageID(instance.getImageID());
        this.withLastState(instance.getLastState());
        this.withName(instance.getName());
        this.withReady(instance.getReady());
        this.withRestartCount(instance.getRestartCount());
        this.withState(instance.getState());
    }

    @Override
    public EditableContainerStatus build() {
        EditableContainerStatus buildable = new EditableContainerStatus(this.fluent.getContainerID(), this.fluent.getImage(), this.fluent.getImageID(), this.fluent.getLastState(), this.fluent.getName(), this.fluent.isReady(), this.fluent.getRestartCount(), this.fluent.getState());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStatusBuilder that = (ContainerStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

