/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.EditableCinderVolumeSource;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CinderVolumeSourceBuilder
extends CinderVolumeSourceFluentImpl<CinderVolumeSourceBuilder>
implements VisitableBuilder<CinderVolumeSource, CinderVolumeSourceBuilder> {
    CinderVolumeSourceFluent<?> fluent;

    public CinderVolumeSourceBuilder() {
        this(new CinderVolumeSource());
    }

    public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent) {
        this(fluent, new CinderVolumeSource());
    }

    public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent, CinderVolumeSource instance) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withVolumeID(instance.getVolumeID());
    }

    public CinderVolumeSourceBuilder(CinderVolumeSource instance) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeID(instance.getVolumeID());
    }

    @Override
    public EditableCinderVolumeSource build() {
        EditableCinderVolumeSource buildable = new EditableCinderVolumeSource(this.fluent.getFsType(), this.fluent.isReadOnly(), this.fluent.getVolumeID());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CinderVolumeSourceBuilder that = (CinderVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

