/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableRouteIngress;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.api.model.RouteIngressFluent;
import io.fabric8.openshift.api.model.RouteIngressFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RouteIngressBuilder
extends RouteIngressFluentImpl<RouteIngressBuilder>
implements VisitableBuilder<RouteIngress, RouteIngressBuilder> {
    RouteIngressFluent<?> fluent;

    public RouteIngressBuilder() {
        this(new RouteIngress());
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent) {
        this(fluent, new RouteIngress());
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent, RouteIngress instance) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withHost(instance.getHost());
        fluent.withRouterName(instance.getRouterName());
    }

    public RouteIngressBuilder(RouteIngress instance) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withHost(instance.getHost());
        this.withRouterName(instance.getRouterName());
    }

    @Override
    public EditableRouteIngress build() {
        EditableRouteIngress buildable = new EditableRouteIngress(this.fluent.getConditions(), this.fluent.getHost(), this.fluent.getRouterName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteIngressBuilder that = (RouteIngressBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

