/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableFCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSource;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.FCVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class FCVolumeSourceBuilder
extends FCVolumeSourceFluentImpl<FCVolumeSourceBuilder>
implements VisitableBuilder<FCVolumeSource, FCVolumeSourceBuilder> {
    FCVolumeSourceFluent<?> fluent;

    public FCVolumeSourceBuilder() {
        this(new FCVolumeSource());
    }

    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent) {
        this(fluent, new FCVolumeSource());
    }

    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent, FCVolumeSource instance) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withLun(instance.getLun());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withTargetWWNs(instance.getTargetWWNs());
    }

    public FCVolumeSourceBuilder(FCVolumeSource instance) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withLun(instance.getLun());
        this.withReadOnly(instance.getReadOnly());
        this.withTargetWWNs(instance.getTargetWWNs());
    }

    @Override
    public EditableFCVolumeSource build() {
        EditableFCVolumeSource buildable = new EditableFCVolumeSource(this.fluent.getFsType(), this.fluent.getLun(), this.fluent.isReadOnly(), this.fluent.getTargetWWNs());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FCVolumeSourceBuilder that = (FCVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

