/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ResourceQuotaSpecBuilder
extends ResourceQuotaSpecFluent<ResourceQuotaSpecBuilder>
implements VisitableBuilder<ResourceQuotaSpec, ResourceQuotaSpecBuilder> {
    ResourceQuotaSpecFluent<?> fluent;

    public ResourceQuotaSpecBuilder() {
        this(new ResourceQuotaSpec());
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent) {
        this(fluent, new ResourceQuotaSpec());
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent, ResourceQuotaSpec instance) {
        this.fluent = fluent;
        fluent.withHard(instance.getHard());
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance) {
        this.fluent = this;
        this.withHard(instance.getHard());
    }

    @Override
    public EditableResourceQuotaSpec build() {
        EditableResourceQuotaSpec buildable = new EditableResourceQuotaSpec(this.fluent.getHard());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

