/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ObjectMetaBuilder
extends ObjectMetaFluent<ObjectMetaBuilder>
implements VisitableBuilder<ObjectMeta, ObjectMetaBuilder> {
    ObjectMetaFluent<?> fluent;

    public ObjectMetaBuilder() {
        this(new ObjectMeta());
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent) {
        this(fluent, new ObjectMeta());
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, ObjectMeta instance) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withDeletionTimestamp(instance.getDeletionTimestamp());
        fluent.withGenerateName(instance.getGenerateName());
        fluent.withGeneration(instance.getGeneration());
        fluent.withLabels(instance.getLabels());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withUid(instance.getUid());
    }

    public ObjectMetaBuilder(ObjectMeta instance) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
    }

    @Override
    public EditableObjectMeta build() {
        EditableObjectMeta buildable = new EditableObjectMeta(this.fluent.getAnnotations(), this.fluent.getCreationTimestamp(), this.fluent.getDeletionTimestamp(), this.fluent.getGenerateName(), this.fluent.getGeneration(), this.fluent.getLabels(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getResourceVersion(), this.fluent.getSelfLink(), this.fluent.getUid());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

