/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableScaleStatus;
import io.fabric8.kubernetes.api.model.extensions.ScaleStatus;
import io.fabric8.kubernetes.api.model.extensions.ScaleStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.ScaleStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ScaleStatusBuilder
extends ScaleStatusFluentImpl<ScaleStatusBuilder>
implements VisitableBuilder<ScaleStatus, ScaleStatusBuilder> {
    ScaleStatusFluent<?> fluent;

    public ScaleStatusBuilder() {
        this(new ScaleStatus());
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent) {
        this(fluent, new ScaleStatus());
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
    }

    public ScaleStatusBuilder(ScaleStatus instance) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
    }

    @Override
    public EditableScaleStatus build() {
        EditableScaleStatus buildable = new EditableScaleStatus(this.fluent.getReplicas(), this.fluent.getSelector());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleStatusBuilder that = (ScaleStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

