/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategy;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.EditableDeploymentStrategy;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentStrategyBuilder
extends DeploymentStrategyFluentImpl<DeploymentStrategyBuilder>
implements VisitableBuilder<DeploymentStrategy, DeploymentStrategyBuilder> {
    DeploymentStrategyFluent<?> fluent;

    public DeploymentStrategyBuilder() {
        this(new DeploymentStrategy());
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent) {
        this(fluent, new DeploymentStrategy());
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent, DeploymentStrategy instance) {
        this.fluent = fluent;
        fluent.withRollingUpdate(instance.getRollingUpdate());
        fluent.withType(instance.getType());
    }

    public DeploymentStrategyBuilder(DeploymentStrategy instance) {
        this.fluent = this;
        this.withRollingUpdate(instance.getRollingUpdate());
        this.withType(instance.getType());
    }

    @Override
    public EditableDeploymentStrategy build() {
        EditableDeploymentStrategy buildable = new EditableDeploymentStrategy(this.fluent.getRollingUpdate(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentStrategyBuilder that = (DeploymentStrategyBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

