/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableTypeMeta;
import io.fabric8.kubernetes.api.model.TypeMeta;
import io.fabric8.kubernetes.api.model.TypeMetaFluent;
import io.fabric8.kubernetes.api.model.TypeMetaFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TypeMetaBuilder
extends TypeMetaFluentImpl<TypeMetaBuilder>
implements VisitableBuilder<TypeMeta, TypeMetaBuilder> {
    TypeMetaFluent<?> fluent;

    public TypeMetaBuilder() {
        this(new TypeMeta());
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent) {
        this(fluent, new TypeMeta());
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, TypeMeta instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
    }

    public TypeMetaBuilder(TypeMeta instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
    }

    @Override
    public EditableTypeMeta build() {
        EditableTypeMeta buildable = new EditableTypeMeta(this.fluent.getApiVersion(), this.fluent.getKind());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeMetaBuilder that = (TypeMetaBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

