/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityContextConstraintsFluentImpl<T extends SecurityContextConstraintsFluent<T>>
extends BaseFluent<T>
implements SecurityContextConstraintsFluent<T> {
    Boolean allowHostDirVolumePlugin;
    Boolean allowHostNetwork;
    Boolean allowHostPorts;
    Boolean allowPrivilegedContainer;
    List<String> allowedCapabilities = new ArrayList<String>();
    SecurityContextConstraints.ApiVersion apiVersion;
    List<String> groups = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<RunAsUserStrategyOptions, ?> runAsUser;
    VisitableBuilder<SELinuxContextStrategyOptions, ?> seLinuxContext;
    List<String> users = new ArrayList<String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public Boolean isAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    @Override
    public T withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (T)this;
    }

    @Override
    public Boolean isAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    @Override
    public T withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (T)this;
    }

    @Override
    public Boolean isAllowHostPorts() {
        return this.allowHostPorts;
    }

    @Override
    public T withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (T)this;
    }

    @Override
    public Boolean isAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    @Override
    public T withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (T)this;
    }

    @Override
    public T addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public T withAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraints.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public T withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? (RunAsUserStrategyOptions)this.runAsUser.build() : null;
    }

    @Override
    public T withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.add(this.runAsUser);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<T> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<T> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<T> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public T withNewRunAsUser(String type, Long uid, Long uidRangeMax, Long uidRangeMin) {
        return this.withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    @Override
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext != null ? (SELinuxContextStrategyOptions)this.seLinuxContext.build() : null;
    }

    @Override
    public T withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        if (seLinuxContext != null) {
            this.seLinuxContext = new SELinuxContextStrategyOptionsBuilder(seLinuxContext);
            this._visitables.add(this.seLinuxContext);
        }
        return (T)this;
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<T> withNewSeLinuxContext() {
        return new SeLinuxContextNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<T> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return new SeLinuxContextNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<T> editSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext());
    }

    @Override
    public T addToUsers(String ... items) {
        for (String item : items) {
            this.users.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromUsers(String ... items) {
        for (String item : items) {
            this.users.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public T withUsers(List<String> users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withUsers(String ... users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl)o;
        if (this.allowHostDirVolumePlugin != null ? !this.allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) : that.allowHostDirVolumePlugin != null) {
            return false;
        }
        if (this.allowHostNetwork != null ? !this.allowHostNetwork.equals(that.allowHostNetwork) : that.allowHostNetwork != null) {
            return false;
        }
        if (this.allowHostPorts != null ? !this.allowHostPorts.equals(that.allowHostPorts) : that.allowHostPorts != null) {
            return false;
        }
        if (this.allowPrivilegedContainer != null ? !this.allowPrivilegedContainer.equals(that.allowPrivilegedContainer) : that.allowPrivilegedContainer != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxContext != null ? !this.seLinuxContext.equals(that.seLinuxContext) : that.seLinuxContext != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SeLinuxContextNestedImpl<N>
    extends SELinuxContextStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>
    implements SecurityContextConstraintsFluent.SeLinuxContextNested<N> {
        private final SELinuxContextStrategyOptionsBuilder builder;

        SeLinuxContextNestedImpl() {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }

        SeLinuxContextNestedImpl(SELinuxContextStrategyOptions item) {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(this.builder.build());
        }

        @Override
        public N endSeLinuxContext() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends RunAsUserStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.RunAsUserNested<N>>
    implements SecurityContextConstraintsFluent.RunAsUserNested<N> {
        private final RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl() {
            this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }

        RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withRunAsUser(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<SecurityContextConstraintsFluent.MetadataNested<N>>
    implements SecurityContextConstraintsFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

