/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.validator;

import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.fabric8.kubernetes.schema.validator.ValidationReport;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class Validator {
    private static final String OPENAPI_SCHEMA = "/openshift-generated.json";
    private final OpenAPI api;
    private final ObjectMapper objectMapper;
    private final SchemaValidator validator;

    private Validator(OpenAPI api) {
        this.api = api;
        this.objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID));
        this.validator = new SchemaValidator(api, new MessageResolver());
    }

    public ValidationReport validate(String content) throws IOException {
        if (content == null) {
            return ValidationReport.EMPTY;
        }
        return this.validate(this.objectMapper.readTree(content));
    }

    public ValidationReport validate(InputStream is) throws IOException {
        if (is == null) {
            return ValidationReport.EMPTY;
        }
        return this.validate(this.objectMapper.readTree(is));
    }

    public ValidationReport validate(JsonNode node) {
        if (node == null) {
            return ValidationReport.EMPTY;
        }
        JsonNode kind = node.path("kind");
        if (kind.isMissingNode()) {
            return ValidationReport.MISSING_KIND;
        }
        String prefix = Validator.findPrefix(node);
        if (prefix == null) {
            return ValidationReport.MISSING_API_VERSION;
        }
        String componentName = prefix.toLowerCase(Locale.ROOT) + "." + kind.asText().toLowerCase(Locale.ROOT);
        Schema s = null;
        for (Map.Entry e : this.api.getComponents().getSchemas().entrySet()) {
            if (!Objects.equals(((String)e.getKey()).toLowerCase(Locale.ROOT), componentName)) continue;
            s = (Schema)e.getValue();
            break;
        }
        if (s == null) {
            return ValidationReport.EMPTY;
        }
        com.atlassian.oai.validator.report.ValidationReport report = this.validator.validate(() -> node, s, "root");
        return ValidationReport.from(report.getMessages());
    }

    private static String findPrefix(JsonNode rootNode) {
        JsonNode apiVersion = rootNode.path("apiVersion");
        if (apiVersion.isMissingNode() || apiVersion.asText().isBlank()) {
            return null;
        }
        if (apiVersion.asText().toLowerCase(Locale.ROOT).equals("v1")) {
            return "io.k8s.api.core.v1";
        }
        String[] apiVersionParts = apiVersion.asText().split("/");
        if (apiVersionParts.length != 2) {
            return null;
        }
        List<String> path = Arrays.asList(apiVersionParts[0].split("\\."));
        if (path.size() == 1) {
            return "io.k8s.api." + path.iterator().next() + "." + apiVersionParts[1];
        }
        Collections.reverse(path);
        return String.join((CharSequence)".", path) + "." + apiVersionParts[1];
    }

    public static Validator newInstance() {
        try {
            String openApiSchema = new String(Objects.requireNonNull(Validator.class.getResourceAsStream(OPENAPI_SCHEMA), "/openshift-generated.json resource not found").readAllBytes(), StandardCharsets.UTF_8);
            ParseOptions options = new ParseOptions();
            for (SwaggerParserExtension extension : OpenAPIV3Parser.getExtensions()) {
                SwaggerParseResult result = extension.readContents(openApiSchema, null, options);
                if (result.getOpenAPI() == null) continue;
                return new Validator(result.getOpenAPI());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IllegalStateException("Failed to parse the OpenAPI schema: /openshift-generated.json");
    }
}

