/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.validator;

import com.atlassian.oai.validator.report.ValidationReport;
import java.util.Map;
import lombok.Generated;

public class ValidationMessage {
    private static final Map<ValidationReport.Level, Level> levelMappings = Map.of(ValidationReport.Level.ERROR, Level.ERROR, ValidationReport.Level.WARN, Level.WARNING, ValidationReport.Level.INFO, Level.INFO, ValidationReport.Level.IGNORE, Level.IGNORE);
    private final Level level;
    private final String schema;
    private final String message;

    public ValidationMessage(Level level, String schema, String message) {
        this.level = level;
        this.schema = schema;
        this.message = message;
    }

    static ValidationMessage from(ValidationReport.Message message) {
        return new ValidationMessage(levelMappings.getOrDefault(message.getLevel(), Level.INFO), message.getContext().map(ValidationReport.MessageContext::getPointers).flatMap(p -> p.map(ValidationReport.MessageContext.Pointers::getSchema)).orElse(null), message.getMessage());
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    public static enum Level {
        ERROR,
        WARNING,
        INFO,
        IGNORE;

    }
}

