package io.fabric8.kubernetes.api.model.node.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RuntimeClassBuilder extends RuntimeClassFluent<RuntimeClassBuilder> implements VisitableBuilder<RuntimeClass,RuntimeClassBuilder>{
  public RuntimeClassBuilder() {
    this(new RuntimeClass());
  }
  
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent) {
    this(fluent, new RuntimeClass());
  }
  
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,RuntimeClass instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RuntimeClassBuilder(RuntimeClass instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RuntimeClassFluent<?> fluent;
  
  public RuntimeClass build() {
    RuntimeClass buildable = new RuntimeClass(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}