package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
public interface NetworkPolicySpecFluent<A extends NetworkPolicySpecFluent<A>> extends Fluent<A>{
  public A addToEgress(Integer index,NetworkPolicyEgressRule item);
  public A setToEgress(Integer index,NetworkPolicyEgressRule item);
  public A addToEgress(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRule... items);
  public A addAllToEgress(Collection<NetworkPolicyEgressRule> items);
  public A removeFromEgress(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRule... items);
  public A removeAllFromEgress(Collection<NetworkPolicyEgressRule> items);
  public A removeMatchingFromEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEgress instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NetworkPolicyEgressRule> getEgress();
  public List<NetworkPolicyEgressRule> buildEgress();
  public NetworkPolicyEgressRule buildEgress(Integer index);
  public NetworkPolicyEgressRule buildFirstEgress();
  public NetworkPolicyEgressRule buildLastEgress();
  public NetworkPolicyEgressRule buildMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
  public Boolean hasMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
  public A withEgress(List<NetworkPolicyEgressRule> egress);
  public A withEgress(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRule... egress);
  public Boolean hasEgress();
  public NetworkPolicySpecFluent.EgressNested<A> addNewEgress();
  public NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(NetworkPolicyEgressRule item);
  public NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(Integer index,NetworkPolicyEgressRule item);
  public NetworkPolicySpecFluent.EgressNested<A> editEgress(Integer index);
  public NetworkPolicySpecFluent.EgressNested<A> editFirstEgress();
  public NetworkPolicySpecFluent.EgressNested<A> editLastEgress();
  public NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
  public A addToIngress(Integer index,NetworkPolicyIngressRule item);
  public A setToIngress(Integer index,NetworkPolicyIngressRule item);
  public A addToIngress(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule... items);
  public A addAllToIngress(Collection<NetworkPolicyIngressRule> items);
  public A removeFromIngress(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule... items);
  public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items);
  public A removeMatchingFromIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NetworkPolicyIngressRule> getIngress();
  public List<NetworkPolicyIngressRule> buildIngress();
  public NetworkPolicyIngressRule buildIngress(Integer index);
  public NetworkPolicyIngressRule buildFirstIngress();
  public NetworkPolicyIngressRule buildLastIngress();
  public NetworkPolicyIngressRule buildMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
  public Boolean hasMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
  public A withIngress(List<NetworkPolicyIngressRule> ingress);
  public A withIngress(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule... ingress);
  public Boolean hasIngress();
  public NetworkPolicySpecFluent.IngressNested<A> addNewIngress();
  public NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item);
  public NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(Integer index,NetworkPolicyIngressRule item);
  public NetworkPolicySpecFluent.IngressNested<A> editIngress(Integer index);
  public NetworkPolicySpecFluent.IngressNested<A> editFirstIngress();
  public NetworkPolicySpecFluent.IngressNested<A> editLastIngress();
  public NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPodSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getPodSelector();
  public LabelSelector buildPodSelector();
  public A withPodSelector(LabelSelector podSelector);
  public Boolean hasPodSelector();
  public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector();
  public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item);
  public NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector();
  public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector();
  public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item);
  public A addToPolicyTypes(Integer index,String item);
  public A setToPolicyTypes(Integer index,String item);
  public A addToPolicyTypes(java.lang.String... items);
  public A addAllToPolicyTypes(Collection<String> items);
  public A removeFromPolicyTypes(java.lang.String... items);
  public A removeAllFromPolicyTypes(Collection<String> items);
  public List<String> getPolicyTypes();
  public String getPolicyType(Integer index);
  public String getFirstPolicyType();
  public String getLastPolicyType();
  public String getMatchingPolicyType(Predicate<String> predicate);
  public Boolean hasMatchingPolicyType(Predicate<String> predicate);
  public A withPolicyTypes(List<String> policyTypes);
  public A withPolicyTypes(java.lang.String... policyTypes);
  public Boolean hasPolicyTypes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface EgressNested<N> extends Nested<N>,NetworkPolicyEgressRuleFluent<NetworkPolicySpecFluent.EgressNested<N>>{
    public N and();
    public N endEgress();
    
  }
  public interface IngressNested<N> extends Nested<N>,NetworkPolicyIngressRuleFluent<NetworkPolicySpecFluent.IngressNested<N>>{
    public N and();
    public N endIngress();
    
  }
  public interface PodSelectorNested<N> extends Nested<N>,LabelSelectorFluent<NetworkPolicySpecFluent.PodSelectorNested<N>>{
    public N and();
    public N endPodSelector();
    
  }
  
}