/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.ReplacementField;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SourceSelector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SourceSelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SourceSelectorFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ReplacementFieldFluent<A extends ReplacementFieldFluent<A>>
extends BaseFluent<A> {
    private String path;
    private SourceSelectorBuilder source;
    private ArrayList<TargetSelectorBuilder> targets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ReplacementFieldFluent() {
    }

    public ReplacementFieldFluent(ReplacementField instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ReplacementField instance) {
        ReplacementField replacementField = instance = instance != null ? instance : new ReplacementField();
        if (instance != null) {
            this.withPath(instance.getPath());
            this.withSource(instance.getSource());
            this.withTargets(instance.getTargets());
            this.withPath(instance.getPath());
            this.withSource(instance.getSource());
            this.withTargets(instance.getTargets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public SourceSelector buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(SourceSelector source) {
        this._visitables.remove((Object)this.source);
        if (source != null) {
            this.source = new SourceSelectorBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove((Object)this.source);
        }
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(SourceSelector item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new SourceSelectorBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(SourceSelector item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public A addToTargets(int index, TargetSelector item) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
        if (index < 0 || index >= this.targets.size()) {
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        } else {
            this._visitables.get((Object)"targets").add(index, builder);
            this.targets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTargets(int index, TargetSelector item) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
        if (index < 0 || index >= this.targets.size()) {
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        } else {
            this._visitables.get((Object)"targets").set(index, builder);
            this.targets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTargets(TargetSelector ... items) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTargets(Collection<TargetSelector> items) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").add(builder);
            this.targets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTargets(TargetSelector ... items) {
        if (this.targets == null) {
            return (A)((Object)this);
        }
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").remove((Object)builder);
            this.targets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargets(Collection<TargetSelector> items) {
        if (this.targets == null) {
            return (A)((Object)this);
        }
        for (TargetSelector item : items) {
            TargetSelectorBuilder builder = new TargetSelectorBuilder(item);
            this._visitables.get((Object)"targets").remove((Object)builder);
            this.targets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTargets(Predicate<TargetSelectorBuilder> predicate) {
        if (this.targets == null) {
            return (A)((Object)this);
        }
        Iterator<TargetSelectorBuilder> each = this.targets.iterator();
        List visitables = this._visitables.get((Object)"targets");
        while (each.hasNext()) {
            TargetSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TargetSelector> buildTargets() {
        return this.targets != null ? ReplacementFieldFluent.build(this.targets) : null;
    }

    public TargetSelector buildTarget(int index) {
        return this.targets.get(index).build();
    }

    public TargetSelector buildFirstTarget() {
        return this.targets.get(0).build();
    }

    public TargetSelector buildLastTarget() {
        return this.targets.get(this.targets.size() - 1).build();
    }

    public TargetSelector buildMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
        for (TargetSelectorBuilder item : this.targets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
        for (TargetSelectorBuilder item : this.targets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargets(List<TargetSelector> targets) {
        if (this.targets != null) {
            this._visitables.get((Object)"targets").clear();
        }
        if (targets != null) {
            this.targets = new ArrayList();
            for (TargetSelector item : targets) {
                this.addToTargets(item);
            }
        } else {
            this.targets = null;
        }
        return (A)((Object)this);
    }

    public A withTargets(TargetSelector ... targets) {
        if (this.targets != null) {
            this.targets.clear();
            this._visitables.remove((Object)"targets");
        }
        if (targets != null) {
            for (TargetSelector item : targets) {
                this.addToTargets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public TargetsNested<A> addNewTarget() {
        return new TargetsNested(-1, null);
    }

    public TargetsNested<A> addNewTargetLike(TargetSelector item) {
        return new TargetsNested(-1, item);
    }

    public TargetsNested<A> setNewTargetLike(int index, TargetSelector item) {
        return new TargetsNested(index, item);
    }

    public TargetsNested<A> editTarget(int index) {
        if (this.targets.size() <= index) {
            throw new RuntimeException("Can't edit targets. Index exceeds size.");
        }
        return this.setNewTargetLike(index, this.buildTarget(index));
    }

    public TargetsNested<A> editFirstTarget() {
        if (this.targets.size() == 0) {
            throw new RuntimeException("Can't edit first targets. The list is empty.");
        }
        return this.setNewTargetLike(0, this.buildTarget(0));
    }

    public TargetsNested<A> editLastTarget() {
        int index = this.targets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last targets. The list is empty.");
        }
        return this.setNewTargetLike(index, this.buildTarget(index));
    }

    public TargetsNested<A> editMatchingTarget(Predicate<TargetSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.targets.size(); ++i) {
            if (!predicate.test(this.targets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching targets. No match found.");
        }
        return this.setNewTargetLike(index, this.buildTarget(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplacementFieldFluent that = (ReplacementFieldFluent)((Object)o);
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)that.source)) {
            return false;
        }
        if (!Objects.equals(this.targets, that.targets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.source, this.targets, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append((Object)((Object)this.source) + ",");
        }
        if (this.targets != null && !this.targets.isEmpty()) {
            sb.append("targets:");
            sb.append(this.targets + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetsNested<N>
    extends TargetSelectorFluent<TargetsNested<N>>
    implements Nested<N> {
        TargetSelectorBuilder builder;
        int index;

        TargetsNested(int index, TargetSelector item) {
            this.index = index;
            this.builder = new TargetSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ReplacementFieldFluent.this.setToTargets(this.index, this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }

    public class SourceNested<N>
    extends SourceSelectorFluent<SourceNested<N>>
    implements Nested<N> {
        SourceSelectorBuilder builder;

        SourceNested(SourceSelector item) {
            this.builder = new SourceSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ReplacementFieldFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

