/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.GeneratorOptions;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.GeneratorOptionsBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.GeneratorOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgs;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SecretArgsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SecretArgsFluentImpl<A extends SecretArgsFluent<A>>
extends BaseFluent<A>
implements SecretArgsFluent<A> {
    private String behavior;
    private String env;
    private List<String> envs = new ArrayList<String>();
    private List<String> files = new ArrayList<String>();
    private List<String> literals = new ArrayList<String>();
    private String name;
    private String namespace;
    private GeneratorOptionsBuilder options;
    private String type;
    private Map<String, Object> additionalProperties;

    public SecretArgsFluentImpl() {
    }

    public SecretArgsFluentImpl(SecretArgs instance) {
        this.withBehavior(instance.getBehavior());
        this.withEnv(instance.getEnv());
        this.withEnvs(instance.getEnvs());
        this.withFiles(instance.getFiles());
        this.withLiterals(instance.getLiterals());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOptions(instance.getOptions());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getBehavior() {
        return this.behavior;
    }

    @Override
    public A withBehavior(String behavior) {
        this.behavior = behavior;
        return (A)this;
    }

    @Override
    public Boolean hasBehavior() {
        return this.behavior != null;
    }

    @Override
    public String getEnv() {
        return this.env;
    }

    @Override
    public A withEnv(String env) {
        this.env = env;
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null;
    }

    @Override
    public A addToEnvs(Integer index, String item) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        this.envs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnvs(Integer index, String item) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        this.envs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnvs(String ... items) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        for (String item : items) {
            this.envs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvs(Collection<String> items) {
        if (this.envs == null) {
            this.envs = new ArrayList<String>();
        }
        for (String item : items) {
            this.envs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvs(String ... items) {
        for (String item : items) {
            if (this.envs == null) continue;
            this.envs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvs(Collection<String> items) {
        for (String item : items) {
            if (this.envs == null) continue;
            this.envs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getEnvs() {
        return this.envs;
    }

    @Override
    public String getEnv(Integer index) {
        return this.envs.get(index);
    }

    @Override
    public String getFirstEnv() {
        return this.envs.get(0);
    }

    @Override
    public String getLastEnv() {
        return this.envs.get(this.envs.size() - 1);
    }

    @Override
    public String getMatchingEnv(Predicate<String> predicate) {
        for (String item : this.envs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<String> predicate) {
        for (String item : this.envs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnvs(List<String> envs) {
        if (envs != null) {
            this.envs = new ArrayList<String>();
            for (String item : envs) {
                this.addToEnvs(item);
            }
        } else {
            this.envs = null;
        }
        return (A)this;
    }

    @Override
    public A withEnvs(String ... envs) {
        if (this.envs != null) {
            this.envs.clear();
        }
        if (envs != null) {
            for (String item : envs) {
                this.addToEnvs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvs() {
        return this.envs != null && !this.envs.isEmpty();
    }

    @Override
    public A addToFiles(Integer index, String item) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFiles(Integer index, String item) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFiles(String ... items) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        for (String item : items) {
            this.files.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFiles(Collection<String> items) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        for (String item : items) {
            this.files.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFiles(String ... items) {
        for (String item : items) {
            if (this.files == null) continue;
            this.files.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFiles(Collection<String> items) {
        for (String item : items) {
            if (this.files == null) continue;
            this.files.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    @Override
    public String getFile(Integer index) {
        return this.files.get(index);
    }

    @Override
    public String getFirstFile() {
        return this.files.get(0);
    }

    @Override
    public String getLastFile() {
        return this.files.get(this.files.size() - 1);
    }

    @Override
    public String getMatchingFile(Predicate<String> predicate) {
        for (String item : this.files) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFile(Predicate<String> predicate) {
        for (String item : this.files) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFiles(List<String> files) {
        if (files != null) {
            this.files = new ArrayList<String>();
            for (String item : files) {
                this.addToFiles(item);
            }
        } else {
            this.files = null;
        }
        return (A)this;
    }

    @Override
    public A withFiles(String ... files) {
        if (this.files != null) {
            this.files.clear();
        }
        if (files != null) {
            for (String item : files) {
                this.addToFiles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFiles() {
        return this.files != null && !this.files.isEmpty();
    }

    @Override
    public A addToLiterals(Integer index, String item) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        this.literals.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLiterals(Integer index, String item) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        this.literals.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLiterals(String ... items) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        for (String item : items) {
            this.literals.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLiterals(Collection<String> items) {
        if (this.literals == null) {
            this.literals = new ArrayList<String>();
        }
        for (String item : items) {
            this.literals.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLiterals(String ... items) {
        for (String item : items) {
            if (this.literals == null) continue;
            this.literals.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLiterals(Collection<String> items) {
        for (String item : items) {
            if (this.literals == null) continue;
            this.literals.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLiterals() {
        return this.literals;
    }

    @Override
    public String getLiteral(Integer index) {
        return this.literals.get(index);
    }

    @Override
    public String getFirstLiteral() {
        return this.literals.get(0);
    }

    @Override
    public String getLastLiteral() {
        return this.literals.get(this.literals.size() - 1);
    }

    @Override
    public String getMatchingLiteral(Predicate<String> predicate) {
        for (String item : this.literals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLiteral(Predicate<String> predicate) {
        for (String item : this.literals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLiterals(List<String> literals) {
        if (literals != null) {
            this.literals = new ArrayList<String>();
            for (String item : literals) {
                this.addToLiterals(item);
            }
        } else {
            this.literals = null;
        }
        return (A)this;
    }

    @Override
    public A withLiterals(String ... literals) {
        if (this.literals != null) {
            this.literals.clear();
        }
        if (literals != null) {
            for (String item : literals) {
                this.addToLiterals(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLiterals() {
        return this.literals != null && !this.literals.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public GeneratorOptions getOptions() {
        return this.options != null ? this.options.build() : null;
    }

    @Override
    public GeneratorOptions buildOptions() {
        return this.options != null ? this.options.build() : null;
    }

    @Override
    public A withOptions(GeneratorOptions options) {
        this._visitables.get((Object)"options").remove(this.options);
        if (options != null) {
            this.options = new GeneratorOptionsBuilder(options);
            this._visitables.get((Object)"options").add(this.options);
        } else {
            this.options = null;
            this._visitables.get((Object)"options").remove(this.options);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null;
    }

    @Override
    public SecretArgsFluent.OptionsNested<A> withNewOptions() {
        return new OptionsNestedImpl();
    }

    @Override
    public SecretArgsFluent.OptionsNested<A> withNewOptionsLike(GeneratorOptions item) {
        return new OptionsNestedImpl(item);
    }

    @Override
    public SecretArgsFluent.OptionsNested<A> editOptions() {
        return this.withNewOptionsLike(this.getOptions());
    }

    @Override
    public SecretArgsFluent.OptionsNested<A> editOrNewOptions() {
        return this.withNewOptionsLike(this.getOptions() != null ? this.getOptions() : new GeneratorOptionsBuilder().build());
    }

    @Override
    public SecretArgsFluent.OptionsNested<A> editOrNewOptionsLike(GeneratorOptions item) {
        return this.withNewOptionsLike(this.getOptions() != null ? this.getOptions() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretArgsFluentImpl that = (SecretArgsFluentImpl)o;
        if (this.behavior != null ? !this.behavior.equals(that.behavior) : that.behavior != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.envs != null ? !this.envs.equals(that.envs) : that.envs != null) {
            return false;
        }
        if (this.files != null ? !this.files.equals(that.files) : that.files != null) {
            return false;
        }
        if (this.literals != null ? !this.literals.equals(that.literals) : that.literals != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.behavior, this.env, this.envs, this.files, this.literals, this.name, this.namespace, this.options, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.behavior != null) {
            sb.append("behavior:");
            sb.append(this.behavior + ",");
        }
        if (this.env != null) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.envs != null && !this.envs.isEmpty()) {
            sb.append("envs:");
            sb.append(this.envs + ",");
        }
        if (this.files != null && !this.files.isEmpty()) {
            sb.append("files:");
            sb.append(this.files + ",");
        }
        if (this.literals != null && !this.literals.isEmpty()) {
            sb.append("literals:");
            sb.append(this.literals + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.options != null) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class OptionsNestedImpl<N>
    extends GeneratorOptionsFluentImpl<SecretArgsFluent.OptionsNested<N>>
    implements SecretArgsFluent.OptionsNested<N>,
    Nested<N> {
        GeneratorOptionsBuilder builder;

        OptionsNestedImpl(GeneratorOptions item) {
            this.builder = new GeneratorOptionsBuilder(this, item);
        }

        OptionsNestedImpl() {
            this.builder = new GeneratorOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretArgsFluentImpl.this.withOptions(this.builder.build());
        }

        @Override
        public N endOptions() {
            return this.and();
        }
    }
}

