package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteSpecBuilder extends HTTPRouteSpecFluentImpl<HTTPRouteSpecBuilder> implements VisitableBuilder<HTTPRouteSpec,HTTPRouteSpecBuilder>{
  public HTTPRouteSpecBuilder() {
    this(false);
  }
  public HTTPRouteSpecBuilder(Boolean validationEnabled) {
    this(new HTTPRouteSpec(), validationEnabled);
  }
  public HTTPRouteSpecBuilder(HTTPRouteSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteSpecBuilder(HTTPRouteSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRouteSpec(), validationEnabled);
  }
  public HTTPRouteSpecBuilder(HTTPRouteSpecFluent<?> fluent,HTTPRouteSpec instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteSpecBuilder(HTTPRouteSpecFluent<?> fluent,HTTPRouteSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostnames(instance.getHostnames()); 
    fluent.withParentRefs(instance.getParentRefs()); 
    fluent.withRules(instance.getRules()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteSpecBuilder(HTTPRouteSpec instance) {
    this(instance,false);
  }
  public HTTPRouteSpecBuilder(HTTPRouteSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostnames(instance.getHostnames()); 
    this.withParentRefs(instance.getParentRefs()); 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteSpecFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRouteSpec build() {
    HTTPRouteSpec buildable = new HTTPRouteSpec(fluent.getHostnames(),fluent.getParentRefs(),fluent.getRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}