package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRequestMirrorFilterBuilder extends HTTPRequestMirrorFilterFluentImpl<HTTPRequestMirrorFilterBuilder> implements VisitableBuilder<HTTPRequestMirrorFilter,HTTPRequestMirrorFilterBuilder>{
  public HTTPRequestMirrorFilterBuilder() {
    this(false);
  }
  public HTTPRequestMirrorFilterBuilder(Boolean validationEnabled) {
    this(new HTTPRequestMirrorFilter(), validationEnabled);
  }
  public HTTPRequestMirrorFilterBuilder(HTTPRequestMirrorFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRequestMirrorFilterBuilder(HTTPRequestMirrorFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRequestMirrorFilter(), validationEnabled);
  }
  public HTTPRequestMirrorFilterBuilder(HTTPRequestMirrorFilterFluent<?> fluent,HTTPRequestMirrorFilter instance) {
    this(fluent, instance, false);
  }
  public HTTPRequestMirrorFilterBuilder(HTTPRequestMirrorFilterFluent<?> fluent,HTTPRequestMirrorFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackendRef(instance.getBackendRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPRequestMirrorFilterBuilder(HTTPRequestMirrorFilter instance) {
    this(instance,false);
  }
  public HTTPRequestMirrorFilterBuilder(HTTPRequestMirrorFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackendRef(instance.getBackendRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPRequestMirrorFilterFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRequestMirrorFilter build() {
    HTTPRequestMirrorFilter buildable = new HTTPRequestMirrorFilter(fluent.getBackendRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}