package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TLSRouteStatusFluentImpl<A extends TLSRouteStatusFluent<A>> extends BaseFluent<A> implements TLSRouteStatusFluent<A>{
  public TLSRouteStatusFluentImpl() {
  }
  public TLSRouteStatusFluentImpl(TLSRouteStatus instance) {
    this.withParents(instance.getParents()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<RouteParentStatusBuilder> parents = new ArrayList<RouteParentStatusBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToParents(Integer index,RouteParentStatus item) {
    if (this.parents == null) {this.parents = new ArrayList<RouteParentStatusBuilder>();}
    RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);_visitables.get("parents").add(index >= 0 ? index : _visitables.get("parents").size(), builder);this.parents.add(index >= 0 ? index : parents.size(), builder); return (A)this;
  }
  public A setToParents(Integer index,RouteParentStatus item) {
    if (this.parents == null) {this.parents = new ArrayList<RouteParentStatusBuilder>();}
    RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("parents").size()) { _visitables.get("parents").add(builder); } else { _visitables.get("parents").set(index, builder);}
    if (index < 0 || index >= parents.size()) { parents.add(builder); } else { parents.set(index, builder);}
     return (A)this;
  }
  public A addToParents(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteParentStatus... items) {
    if (this.parents == null) {this.parents = new ArrayList<RouteParentStatusBuilder>();}
    for (RouteParentStatus item : items) {RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);_visitables.get("parents").add(builder);this.parents.add(builder);} return (A)this;
  }
  public A addAllToParents(Collection<RouteParentStatus> items) {
    if (this.parents == null) {this.parents = new ArrayList<RouteParentStatusBuilder>();}
    for (RouteParentStatus item : items) {RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);_visitables.get("parents").add(builder);this.parents.add(builder);} return (A)this;
  }
  public A removeFromParents(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteParentStatus... items) {
    for (RouteParentStatus item : items) {RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);_visitables.get("parents").remove(builder);if (this.parents != null) {this.parents.remove(builder);}} return (A)this;
  }
  public A removeAllFromParents(Collection<RouteParentStatus> items) {
    for (RouteParentStatus item : items) {RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);_visitables.get("parents").remove(builder);if (this.parents != null) {this.parents.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParents(Predicate<RouteParentStatusBuilder> predicate) {
    if (parents == null) return (A) this;
    final Iterator<RouteParentStatusBuilder> each = parents.iterator();
    final List visitables = _visitables.get("parents");
    while (each.hasNext()) {
      RouteParentStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParents instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RouteParentStatus> getParents() {
    return parents != null ? build(parents) : null;
  }
  public List<RouteParentStatus> buildParents() {
    return parents != null ? build(parents) : null;
  }
  public RouteParentStatus buildParent(Integer index) {
    return this.parents.get(index).build();
  }
  public RouteParentStatus buildFirstParent() {
    return this.parents.get(0).build();
  }
  public RouteParentStatus buildLastParent() {
    return this.parents.get(parents.size() - 1).build();
  }
  public RouteParentStatus buildMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
    for (RouteParentStatusBuilder item: parents) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
    for (RouteParentStatusBuilder item: parents) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParents(List<RouteParentStatus> parents) {
    if (this.parents != null) { _visitables.get("parents").removeAll(this.parents);}
    if (parents != null) {this.parents = new ArrayList(); for (RouteParentStatus item : parents){this.addToParents(item);}} else { this.parents = null;} return (A) this;
  }
  public A withParents(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteParentStatus... parents) {
    if (this.parents != null) {this.parents.clear();}
    if (parents != null) {for (RouteParentStatus item :parents){ this.addToParents(item);}} return (A) this;
  }
  public Boolean hasParents() {
    return parents != null && !parents.isEmpty();
  }
  public TLSRouteStatusFluent.ParentsNested<A> addNewParent() {
    return new TLSRouteStatusFluentImpl.ParentsNestedImpl();
  }
  public TLSRouteStatusFluent.ParentsNested<A> addNewParentLike(RouteParentStatus item) {
    return new TLSRouteStatusFluentImpl.ParentsNestedImpl(-1, item);
  }
  public TLSRouteStatusFluent.ParentsNested<A> setNewParentLike(Integer index,RouteParentStatus item) {
    return new TLSRouteStatusFluentImpl.ParentsNestedImpl(index, item);
  }
  public TLSRouteStatusFluent.ParentsNested<A> editParent(Integer index) {
    if (parents.size() <= index) throw new RuntimeException("Can't edit parents. Index exceeds size.");
    return setNewParentLike(index, buildParent(index));
  }
  public TLSRouteStatusFluent.ParentsNested<A> editFirstParent() {
    if (parents.size() == 0) throw new RuntimeException("Can't edit first parents. The list is empty.");
    return setNewParentLike(0, buildParent(0));
  }
  public TLSRouteStatusFluent.ParentsNested<A> editLastParent() {
    int index = parents.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parents. The list is empty.");
    return setNewParentLike(index, buildParent(index));
  }
  public TLSRouteStatusFluent.ParentsNested<A> editMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parents.size();i++) { 
    if (predicate.test(parents.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parents. No match found.");
    return setNewParentLike(index, buildParent(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TLSRouteStatusFluentImpl that = (TLSRouteStatusFluentImpl) o;
    if (parents != null ? !parents.equals(that.parents) :that.parents != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(parents,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (parents != null && !parents.isEmpty()) { sb.append("parents:"); sb.append(parents + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ParentsNestedImpl<N> extends RouteParentStatusFluentImpl<TLSRouteStatusFluent.ParentsNested<N>> implements TLSRouteStatusFluent.ParentsNested<N>,Nested<N>{
    ParentsNestedImpl(Integer index,RouteParentStatus item) {
      this.index = index;
      this.builder = new RouteParentStatusBuilder(this, item);
    }
    ParentsNestedImpl() {
      this.index = -1;
      this.builder = new RouteParentStatusBuilder(this);
    }
    RouteParentStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) TLSRouteStatusFluentImpl.this.setToParents(index,builder.build());
    }
    public N endParent() {
      return and();
    }
    
  }
  
}