package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReferenceGrantBuilder extends ReferenceGrantFluentImpl<ReferenceGrantBuilder> implements VisitableBuilder<ReferenceGrant,ReferenceGrantBuilder>{
  public ReferenceGrantBuilder() {
    this(false);
  }
  public ReferenceGrantBuilder(Boolean validationEnabled) {
    this(new ReferenceGrant(), validationEnabled);
  }
  public ReferenceGrantBuilder(ReferenceGrantFluent<?> fluent) {
    this(fluent, false);
  }
  public ReferenceGrantBuilder(ReferenceGrantFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReferenceGrant(), validationEnabled);
  }
  public ReferenceGrantBuilder(ReferenceGrantFluent<?> fluent,ReferenceGrant instance) {
    this(fluent, instance, false);
  }
  public ReferenceGrantBuilder(ReferenceGrantFluent<?> fluent,ReferenceGrant instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReferenceGrantBuilder(ReferenceGrant instance) {
    this(instance,false);
  }
  public ReferenceGrantBuilder(ReferenceGrant instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReferenceGrantFluent<?> fluent;
  Boolean validationEnabled;
  public ReferenceGrant build() {
    ReferenceGrant buildable = new ReferenceGrant(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}