package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRequestHeaderFilterBuilder extends HTTPRequestHeaderFilterFluentImpl<HTTPRequestHeaderFilterBuilder> implements VisitableBuilder<HTTPRequestHeaderFilter,HTTPRequestHeaderFilterBuilder>{
  public HTTPRequestHeaderFilterBuilder() {
    this(false);
  }
  public HTTPRequestHeaderFilterBuilder(Boolean validationEnabled) {
    this(new HTTPRequestHeaderFilter(), validationEnabled);
  }
  public HTTPRequestHeaderFilterBuilder(HTTPRequestHeaderFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRequestHeaderFilterBuilder(HTTPRequestHeaderFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRequestHeaderFilter(), validationEnabled);
  }
  public HTTPRequestHeaderFilterBuilder(HTTPRequestHeaderFilterFluent<?> fluent,HTTPRequestHeaderFilter instance) {
    this(fluent, instance, false);
  }
  public HTTPRequestHeaderFilterBuilder(HTTPRequestHeaderFilterFluent<?> fluent,HTTPRequestHeaderFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdd(instance.getAdd()); 
    fluent.withRemove(instance.getRemove()); 
    fluent.withSet(instance.getSet()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPRequestHeaderFilterBuilder(HTTPRequestHeaderFilter instance) {
    this(instance,false);
  }
  public HTTPRequestHeaderFilterBuilder(HTTPRequestHeaderFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdd(instance.getAdd()); 
    this.withRemove(instance.getRemove()); 
    this.withSet(instance.getSet()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPRequestHeaderFilterFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRequestHeaderFilter build() {
    HTTPRequestHeaderFilter buildable = new HTTPRequestHeaderFilter(fluent.getAdd(),fluent.getRemove(),fluent.getSet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}