/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl;
import java.util.Objects;

public class HTTPIngressPathFluentImpl<A extends HTTPIngressPathFluent<A>>
extends BaseFluent<A>
implements HTTPIngressPathFluent<A> {
    private IngressBackendBuilder backend;
    private String path;
    private String pathType;

    public HTTPIngressPathFluentImpl() {
    }

    public HTTPIngressPathFluentImpl(HTTPIngressPath instance) {
        this.withBackend(instance.getBackend());
        this.withPath(instance.getPath());
        this.withPathType(instance.getPathType());
    }

    @Override
    @Deprecated
    public IngressBackend getBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public IngressBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public A withBackend(IngressBackend backend) {
        this._visitables.get((Object)"backend").remove(this.backend);
        if (backend != null) {
            this.backend = new IngressBackendBuilder(backend);
            this._visitables.get((Object)"backend").add(this.backend);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackend() {
        return this.backend != null;
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> withNewBackend() {
        return new BackendNestedImpl();
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> withNewBackendLike(IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> editBackend() {
        return this.withNewBackendLike(this.getBackend());
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : new IngressBackendBuilder().build());
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> editOrNewBackendLike(IngressBackend item) {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : item);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String arg0) {
        return this.withPath(new String(arg0));
    }

    @Override
    public String getPathType() {
        return this.pathType;
    }

    @Override
    public A withPathType(String pathType) {
        this.pathType = pathType;
        return (A)this;
    }

    @Override
    public Boolean hasPathType() {
        return this.pathType != null;
    }

    @Override
    @Deprecated
    public A withNewPathType(String arg0) {
        return this.withPathType(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPIngressPathFluentImpl that = (HTTPIngressPathFluentImpl)o;
        if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return !(this.pathType != null ? !this.pathType.equals(that.pathType) : that.pathType != null);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType, super.hashCode());
    }

    public class BackendNestedImpl<N>
    extends IngressBackendFluentImpl<HTTPIngressPathFluent.BackendNested<N>>
    implements HTTPIngressPathFluent.BackendNested<N>,
    Nested<N> {
        private final IngressBackendBuilder builder;

        BackendNestedImpl(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        BackendNestedImpl() {
            this.builder = new IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPIngressPathFluentImpl.this.withBackend(this.builder.build());
        }

        @Override
        public N endBackend() {
            return this.and();
        }
    }
}

