package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointHintsBuilder extends EndpointHintsFluentImpl<EndpointHintsBuilder> implements VisitableBuilder<EndpointHints,EndpointHintsBuilder>{
  public EndpointHintsBuilder() {
    this(false);
  }
  public EndpointHintsBuilder(Boolean validationEnabled) {
    this(new EndpointHints(), validationEnabled);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointHints(), validationEnabled);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent,EndpointHints instance) {
    this(fluent, instance, false);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent,EndpointHints instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withForZones(instance.getForZones()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointHintsBuilder(EndpointHints instance) {
    this(instance,false);
  }
  public EndpointHintsBuilder(EndpointHints instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withForZones(instance.getForZones()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EndpointHintsFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointHints build() {
    EndpointHints buildable = new EndpointHints(fluent.getForZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}