package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceStatusBuilder extends ResourceStatusFluent<ResourceStatusBuilder> implements VisitableBuilder<ResourceStatus,ResourceStatusBuilder>{
  public ResourceStatusBuilder() {
    this(new ResourceStatus());
  }
  
  public ResourceStatusBuilder(ResourceStatusFluent<?> fluent) {
    this(fluent, new ResourceStatus());
  }
  
  public ResourceStatusBuilder(ResourceStatusFluent<?> fluent,ResourceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceStatusBuilder(ResourceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceStatusFluent<?> fluent;
  
  public ResourceStatus build() {
    ResourceStatus buildable = new ResourceStatus(fluent.getName(),fluent.buildResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}