package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeStatusBuilder extends NodeStatusFluent<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,NodeStatusBuilder>{
  public NodeStatusBuilder() {
    this(new NodeStatus());
  }
  
  public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
    this(fluent, new NodeStatus());
  }
  
  public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeStatusBuilder(NodeStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeStatusFluent<?> fluent;
  
  public NodeStatus build() {
    NodeStatus buildable = new NodeStatus(fluent.buildAddresses(),fluent.getAllocatable(),fluent.getCapacity(),fluent.buildConditions(),fluent.buildConfig(),fluent.buildDaemonEndpoints(),fluent.buildFeatures(),fluent.buildImages(),fluent.buildNodeInfo(),fluent.getPhase(),fluent.buildRuntimeHandlers(),fluent.buildVolumesAttached(),fluent.getVolumesInUse());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}