package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LinuxContainerUserBuilder extends LinuxContainerUserFluent<LinuxContainerUserBuilder> implements VisitableBuilder<LinuxContainerUser,LinuxContainerUserBuilder>{
  public LinuxContainerUserBuilder() {
    this(new LinuxContainerUser());
  }
  
  public LinuxContainerUserBuilder(LinuxContainerUserFluent<?> fluent) {
    this(fluent, new LinuxContainerUser());
  }
  
  public LinuxContainerUserBuilder(LinuxContainerUserFluent<?> fluent,LinuxContainerUser instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LinuxContainerUserBuilder(LinuxContainerUser instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LinuxContainerUserFluent<?> fluent;
  
  public LinuxContainerUser build() {
    LinuxContainerUser buildable = new LinuxContainerUser(fluent.getGid(),fluent.getSupplementalGroups(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}