package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerUserFluent<A extends ContainerUserFluent<A>> extends BaseFluent<A>{
  public ContainerUserFluent() {
  }
  
  public ContainerUserFluent(ContainerUser instance) {
    this.copyInstance(instance);
  }
  private LinuxContainerUserBuilder linux;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ContainerUser instance) {
    instance = (instance != null ? instance : new ContainerUser());
    if (instance != null) {
          this.withLinux(instance.getLinux());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LinuxContainerUser buildLinux() {
    return this.linux != null ? this.linux.build() : null;
  }
  
  public A withLinux(LinuxContainerUser linux) {
    this._visitables.remove("linux");
    if (linux != null) {
        this.linux = new LinuxContainerUserBuilder(linux);
        this._visitables.get("linux").add(this.linux);
    } else {
        this.linux = null;
        this._visitables.get("linux").remove(this.linux);
    }
    return (A) this;
  }
  
  public boolean hasLinux() {
    return this.linux != null;
  }
  
  public LinuxNested<A> withNewLinux() {
    return new LinuxNested(null);
  }
  
  public LinuxNested<A> withNewLinuxLike(LinuxContainerUser item) {
    return new LinuxNested(item);
  }
  
  public LinuxNested<A> editLinux() {
    return withNewLinuxLike(java.util.Optional.ofNullable(buildLinux()).orElse(null));
  }
  
  public LinuxNested<A> editOrNewLinux() {
    return withNewLinuxLike(java.util.Optional.ofNullable(buildLinux()).orElse(new LinuxContainerUserBuilder().build()));
  }
  
  public LinuxNested<A> editOrNewLinuxLike(LinuxContainerUser item) {
    return withNewLinuxLike(java.util.Optional.ofNullable(buildLinux()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerUserFluent that = (ContainerUserFluent) o;
    if (!java.util.Objects.equals(linux, that.linux)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(linux,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (linux != null) { sb.append("linux:"); sb.append(linux + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LinuxNested<N> extends LinuxContainerUserFluent<LinuxNested<N>> implements Nested<N>{
    LinuxNested(LinuxContainerUser item) {
      this.builder = new LinuxContainerUserBuilder(this, item);
    }
    LinuxContainerUserBuilder builder;
    
    public N and() {
      return (N) ContainerUserFluent.this.withLinux(builder.build());
    }
    
    public N endLinux() {
      return and();
    }
    
  
  }

}