/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "automountServiceAccountToken", "imagePullSecrets", "secrets"})
@Version(value="v1")
@Group(value="")
public class ServiceAccount
implements Editable<ServiceAccountBuilder>,
HasMetadata,
Namespaced {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1";
    @JsonProperty(value="automountServiceAccountToken")
    private Boolean automountServiceAccountToken;
    @JsonProperty(value="imagePullSecrets")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
    @JsonProperty(value="kind")
    private String kind = "ServiceAccount";
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ObjectReference> secrets = new ArrayList<ObjectReference>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ServiceAccount() {
    }

    public ServiceAccount(String apiVersion, Boolean automountServiceAccountToken, List<LocalObjectReference> imagePullSecrets, String kind, ObjectMeta metadata, List<ObjectReference> secrets) {
        this.apiVersion = apiVersion;
        this.automountServiceAccountToken = automountServiceAccountToken;
        this.imagePullSecrets = imagePullSecrets;
        this.kind = kind;
        this.metadata = metadata;
        this.secrets = secrets;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="automountServiceAccountToken")
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @JsonProperty(value="automountServiceAccountToken")
    public void setAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
    }

    @JsonProperty(value="imagePullSecrets")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @JsonProperty(value="imagePullSecrets")
    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ObjectReference> getSecrets() {
        return this.secrets;
    }

    @JsonProperty(value="secrets")
    public void setSecrets(List<ObjectReference> secrets) {
        this.secrets = secrets;
    }

    @JsonIgnore
    public ServiceAccountBuilder edit() {
        return new ServiceAccountBuilder(this);
    }

    @JsonIgnore
    public ServiceAccountBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "ServiceAccount(apiVersion=" + this.getApiVersion() + ", automountServiceAccountToken=" + this.getAutomountServiceAccountToken() + ", imagePullSecrets=" + String.valueOf(this.getImagePullSecrets()) + ", kind=" + this.getKind() + ", metadata=" + String.valueOf(this.getMetadata()) + ", secrets=" + String.valueOf(this.getSecrets()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceAccount)) {
            return false;
        }
        ServiceAccount other = (ServiceAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$automountServiceAccountToken = this.getAutomountServiceAccountToken();
        Boolean other$automountServiceAccountToken = other.getAutomountServiceAccountToken();
        if (this$automountServiceAccountToken == null ? other$automountServiceAccountToken != null : !((Object)this$automountServiceAccountToken).equals(other$automountServiceAccountToken)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        List<LocalObjectReference> this$imagePullSecrets = this.getImagePullSecrets();
        List<LocalObjectReference> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<ObjectReference> this$secrets = this.getSecrets();
        List<ObjectReference> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $automountServiceAccountToken = this.getAutomountServiceAccountToken();
        result = result * 59 + ($automountServiceAccountToken == null ? 43 : ((Object)$automountServiceAccountToken).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        List<LocalObjectReference> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<ObjectReference> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

